/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.apache.flink.runtime.rest.handler.job.SubtaskCurrentAttemptDetailsHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.SubtaskCurrentAttemptDetailsHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsInfo;
import org.apache.flink.runtime.rest.messages.job.SubtaskMessageParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.util.EvictingBoundedList;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class SubtaskCurrentAttemptDetailsHandlerTest
extends TestLogger {
    @Test
    public void testHandleRequest() throws Exception {
        JobID jobID = new JobID();
        JobVertexID jobVertexID = new JobVertexID();
        long deployingTs = System.currentTimeMillis() - 1024L;
        long finishedTs = System.currentTimeMillis();
        long bytesInLocal = 1L;
        long bytesInRemote = 2L;
        long bytesOut = 10L;
        long recordsIn = 20L;
        long recordsOut = 30L;
        IOMetrics ioMetrics = new IOMetrics(1L, 2L, 10L, 20L, 30L, 0.0, 0.0, 0.0, 0.0, 0.0);
        long[] timestamps = new long[ExecutionState.values().length];
        timestamps[ExecutionState.DEPLOYING.ordinal()] = deployingTs;
        ExecutionState expectedState = ExecutionState.FINISHED;
        timestamps[expectedState.ordinal()] = finishedTs;
        LocalTaskManagerLocation assignedResourceLocation = new LocalTaskManagerLocation();
        AllocationID allocationID = new AllocationID();
        boolean subtaskIndex = true;
        int attempt = 2;
        ArchivedExecution execution = new ArchivedExecution(new StringifiedAccumulatorResult[0], ioMetrics, new ExecutionAttemptID(), 2, expectedState, null, (TaskManagerLocation)assignedResourceLocation, allocationID, 1, timestamps);
        ArchivedExecutionVertex executionVertex = new ArchivedExecutionVertex(1, "Test archived execution vertex", execution, new EvictingBoundedList(0));
        RestHandlerConfiguration restHandlerConfiguration = RestHandlerConfiguration.fromConfiguration((Configuration)new Configuration());
        MetricFetcher metricFetcher = new MetricFetcher(() -> null, path -> null, (Executor)TestingUtils.defaultExecutor(), Time.milliseconds((long)1000L));
        SubtaskCurrentAttemptDetailsHandler handler = new SubtaskCurrentAttemptDetailsHandler(CompletableFuture.completedFuture("127.0.0.1:9527"), () -> null, Time.milliseconds((long)100L), Collections.emptyMap(), (MessageHeaders)SubtaskCurrentAttemptDetailsHeaders.getInstance(), new ExecutionGraphCache(restHandlerConfiguration.getTimeout(), Time.milliseconds((long)restHandlerConfiguration.getRefreshInterval())), (Executor)TestingUtils.defaultExecutor(), metricFetcher);
        HashMap<String, String> receivedPathParameters = new HashMap<String, String>(2);
        receivedPathParameters.put("jobid", jobID.toString());
        receivedPathParameters.put("vertexid", jobVertexID.toString());
        HandlerRequest request = new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new SubtaskMessageParameters(), receivedPathParameters, Collections.emptyMap());
        SubtaskExecutionAttemptDetailsInfo detailsInfo = handler.handleRequest(request, (AccessExecutionVertex)executionVertex);
        IOMetricsInfo ioMetricsInfo = new IOMetricsInfo(3L, true, 10L, true, 20L, true, 30L, true);
        SubtaskExecutionAttemptDetailsInfo expectedDetailsInfo = new SubtaskExecutionAttemptDetailsInfo(1, expectedState, 2, assignedResourceLocation.getHostname(), deployingTs, finishedTs, finishedTs - deployingTs, ioMetricsInfo);
        Assert.assertEquals((Object)expectedDetailsInfo, (Object)detailsInfo);
    }
}

