/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.akka.AkkaJobManagerGateway;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.rest.handler.util.HandlerRedirectUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class HandlerRedirectUtilsTest
extends TestLogger {
    private static final String localRestAddress = "http://127.0.0.1:1234";
    private static final String remoteRestAddress = "http://127.0.0.2:1234";

    @Test
    public void testGetRedirectAddressWithLocalEqualsRemoteRESTAddress() throws Exception {
        JobManagerGateway jobManagerGateway = (JobManagerGateway)Mockito.mock(JobManagerGateway.class);
        Mockito.when((Object)jobManagerGateway.requestRestAddress((Time)Matchers.any(Time.class))).thenReturn(CompletableFuture.completedFuture(localRestAddress));
        CompletableFuture redirectingAddressFuture = HandlerRedirectUtils.getRedirectAddress((String)localRestAddress, (RestfulGateway)jobManagerGateway, (Time)Time.seconds((long)3L));
        Assert.assertTrue((boolean)redirectingAddressFuture.isDone());
        Assert.assertFalse((boolean)((Optional)redirectingAddressFuture.get()).isPresent());
    }

    @Test
    public void testGetRedirectAddressWithRemoteAkkaPath() throws Exception {
        JobManagerGateway jobManagerGateway = (JobManagerGateway)Mockito.mock(AkkaJobManagerGateway.class);
        Mockito.when((Object)jobManagerGateway.requestRestAddress((Time)Matchers.any(Time.class))).thenReturn(CompletableFuture.completedFuture(remoteRestAddress));
        CompletableFuture optRedirectingAddress = HandlerRedirectUtils.getRedirectAddress((String)localRestAddress, (RestfulGateway)jobManagerGateway, (Time)Time.seconds((long)3L));
        Assert.assertTrue((boolean)optRedirectingAddress.isDone());
        Assert.assertEquals((Object)remoteRestAddress, ((Optional)optRedirectingAddress.get()).get());
    }
}

