/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.utils;

import java.util.Random;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class ArchivedExecutionJobVertexBuilder {
    private static final Random RANDOM = new Random();
    private ArchivedExecutionVertex[] taskVertices;
    private JobVertexID id;
    private String name;
    private int parallelism;
    private int maxParallelism;
    private StringifiedAccumulatorResult[] archivedUserAccumulators;

    public ArchivedExecutionJobVertexBuilder setTaskVertices(ArchivedExecutionVertex[] taskVertices) {
        this.taskVertices = taskVertices;
        return this;
    }

    public ArchivedExecutionJobVertexBuilder setId(JobVertexID id) {
        this.id = id;
        return this;
    }

    public ArchivedExecutionJobVertexBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ArchivedExecutionJobVertexBuilder setParallelism(int parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    public ArchivedExecutionJobVertexBuilder setMaxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
        return this;
    }

    public ArchivedExecutionJobVertexBuilder setArchivedUserAccumulators(StringifiedAccumulatorResult[] archivedUserAccumulators) {
        this.archivedUserAccumulators = archivedUserAccumulators;
        return this;
    }

    public ArchivedExecutionJobVertex build() {
        Preconditions.checkNotNull((Object)this.taskVertices);
        return new ArchivedExecutionJobVertex(this.taskVertices, this.id != null ? this.id : new JobVertexID(), this.name != null ? this.name : "task_" + RANDOM.nextInt(), this.parallelism, this.maxParallelism, this.archivedUserAccumulators != null ? this.archivedUserAccumulators : new StringifiedAccumulatorResult[]{});
    }
}

