/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import akka.actor.ActorSystem;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcService;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import scala.concurrent.Future;

public class RpcEndpointTest
extends TestLogger {
    private static final Time TIMEOUT = Time.seconds((long)10L);
    private static ActorSystem actorSystem = null;
    private static RpcService rpcService = null;

    @BeforeClass
    public static void setup() {
        actorSystem = AkkaUtils.createDefaultActorSystem();
        rpcService = new AkkaRpcService(actorSystem, TIMEOUT);
    }

    @AfterClass
    public static void teardown() throws Exception {
        CompletableFuture rpcTerminationFuture = rpcService.stopService();
        CompletableFuture actorSystemTerminationFuture = FutureUtils.toJava((Future)actorSystem.terminate());
        FutureUtils.waitForAll(Arrays.asList(rpcTerminationFuture, actorSystemTerminationFuture)).get(TIMEOUT.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelfGateway() throws Exception {
        int expectedValue = 1337;
        BaseEndpoint baseEndpoint = new BaseEndpoint(rpcService, expectedValue);
        try {
            baseEndpoint.start();
            BaseGateway baseGateway = (BaseGateway)baseEndpoint.getSelfGateway(BaseGateway.class);
            CompletableFuture<Integer> foobar = baseGateway.foobar();
            Assert.assertEquals((Object)expectedValue, (Object)foobar.get());
        }
        finally {
            baseEndpoint.shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RuntimeException.class)
    public void testWrongSelfGateway() throws Exception {
        int expectedValue = 1337;
        BaseEndpoint baseEndpoint = new BaseEndpoint(rpcService, expectedValue);
        try {
            baseEndpoint.start();
            DifferentGateway differentGateway = (DifferentGateway)baseEndpoint.getSelfGateway(DifferentGateway.class);
            Assert.fail((String)"Expected to fail with a RuntimeException since we requested the wrong gateway type.");
        }
        finally {
            baseEndpoint.shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEndpointInheritance() throws Exception {
        int foobar = 1;
        int barfoo = 2;
        String foo = "foobar";
        ExtendedEndpoint endpoint = new ExtendedEndpoint(rpcService, foobar, barfoo, foo);
        try {
            endpoint.start();
            BaseGateway baseGateway = (BaseGateway)endpoint.getSelfGateway(BaseGateway.class);
            ExtendedGateway extendedGateway = (ExtendedGateway)endpoint.getSelfGateway(ExtendedGateway.class);
            DifferentGateway differentGateway = (DifferentGateway)endpoint.getSelfGateway(DifferentGateway.class);
            Assert.assertEquals((Object)foobar, (Object)baseGateway.foobar().get());
            Assert.assertEquals((Object)foobar, (Object)extendedGateway.foobar().get());
            Assert.assertEquals((Object)barfoo, (Object)extendedGateway.barfoo().get());
            Assert.assertEquals((Object)foo, (Object)differentGateway.foo().get());
        }
        finally {
            endpoint.shutDown();
        }
    }

    public static class ExtendedEndpoint
    extends BaseEndpoint
    implements ExtendedGateway,
    DifferentGateway {
        private final int barfooValue;
        private final String fooString;

        protected ExtendedEndpoint(RpcService rpcService, int foobarValue, int barfooValue, String fooString) {
            super(rpcService, foobarValue);
            this.barfooValue = barfooValue;
            this.fooString = fooString;
        }

        @Override
        public CompletableFuture<Integer> barfoo() {
            return CompletableFuture.completedFuture(this.barfooValue);
        }

        @Override
        public CompletableFuture<String> foo() {
            return CompletableFuture.completedFuture(this.fooString);
        }
    }

    public static class BaseEndpoint
    extends RpcEndpoint
    implements BaseGateway {
        private final int foobarValue;

        protected BaseEndpoint(RpcService rpcService, int foobarValue) {
            super(rpcService);
            this.foobarValue = foobarValue;
        }

        @Override
        public CompletableFuture<Integer> foobar() {
            return CompletableFuture.completedFuture(this.foobarValue);
        }

        public CompletableFuture<Void> postStop() {
            return CompletableFuture.completedFuture(null);
        }
    }

    public static interface DifferentGateway
    extends RpcGateway {
        public CompletableFuture<String> foo();
    }

    public static interface ExtendedGateway
    extends BaseGateway {
        public CompletableFuture<Integer> barfoo();
    }

    public static interface BaseGateway
    extends RpcGateway {
        public CompletableFuture<Integer> foobar();
    }
}

