/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.security.HadoopSecurityContext;
import org.apache.flink.runtime.security.NoOpSecurityContext;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.security.modules.SecurityModule;
import org.apache.flink.runtime.security.modules.SecurityModuleFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class SecurityUtilsTest {
    @AfterClass
    public static void afterClass() {
        SecurityUtils.uninstall();
    }

    @Test
    public void testModuleInstall() throws Exception {
        SecurityConfiguration sc = new SecurityConfiguration(new Configuration(), Collections.singletonList(new TestSecurityModule.Factory()));
        SecurityUtils.install((SecurityConfiguration)sc);
        Assert.assertEquals((long)1L, (long)SecurityUtils.getInstalledModules().size());
        TestSecurityModule testModule = (TestSecurityModule)SecurityUtils.getInstalledModules().get(0);
        Assert.assertTrue((boolean)testModule.installed);
        SecurityUtils.uninstall();
        Assert.assertNull((Object)SecurityUtils.getInstalledModules());
        Assert.assertFalse((boolean)testModule.installed);
    }

    @Test
    public void testSecurityContext() throws Exception {
        SecurityConfiguration sc = new SecurityConfiguration(new Configuration(), Collections.singletonList(new TestSecurityModule.Factory()));
        SecurityUtils.install((SecurityConfiguration)sc);
        Assert.assertEquals(HadoopSecurityContext.class, SecurityUtils.getInstalledContext().getClass());
        SecurityUtils.uninstall();
        Assert.assertEquals(NoOpSecurityContext.class, SecurityUtils.getInstalledContext().getClass());
    }

    @Test
    public void testKerberosLoginContextParsing() {
        List<String> expectedLoginContexts = Arrays.asList("Foo bar", "Client");
        Configuration testFlinkConf = new Configuration();
        testFlinkConf.setString(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, "Foo bar,Client");
        SecurityConfiguration testSecurityConf = new SecurityConfiguration(testFlinkConf, Collections.singletonList(new TestSecurityModule.Factory()));
        Assert.assertEquals(expectedLoginContexts, (Object)testSecurityConf.getLoginContextNames());
        testFlinkConf = new Configuration();
        testFlinkConf.setString(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, "Foo bar , Client");
        testSecurityConf = new SecurityConfiguration(testFlinkConf, Collections.singletonList(new TestSecurityModule.Factory()));
        Assert.assertEquals(expectedLoginContexts, (Object)testSecurityConf.getLoginContextNames());
        testFlinkConf = new Configuration();
        testFlinkConf.setString(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, " Foo bar , Client ");
        testSecurityConf = new SecurityConfiguration(testFlinkConf, Collections.singletonList(new TestSecurityModule.Factory()));
        Assert.assertEquals(expectedLoginContexts, (Object)testSecurityConf.getLoginContextNames());
        testFlinkConf = new Configuration();
        testFlinkConf.setString(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, "Foo bar,,Client");
        testSecurityConf = new SecurityConfiguration(testFlinkConf, Collections.singletonList(new TestSecurityModule.Factory()));
        Assert.assertEquals(expectedLoginContexts, (Object)testSecurityConf.getLoginContextNames());
        testFlinkConf = new Configuration();
        testFlinkConf.setString(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, "Foo bar, ,, Client,");
        testSecurityConf = new SecurityConfiguration(testFlinkConf, Collections.singletonList(new TestSecurityModule.Factory()));
        Assert.assertEquals(expectedLoginContexts, (Object)testSecurityConf.getLoginContextNames());
    }

    static class TestSecurityModule
    implements SecurityModule {
        boolean installed;

        TestSecurityModule() {
        }

        public void install() throws SecurityModule.SecurityInstallException {
            this.installed = true;
        }

        public void uninstall() throws SecurityModule.SecurityInstallException {
            this.installed = false;
        }

        static class Factory
        implements SecurityModuleFactory {
            Factory() {
            }

            public SecurityModule createModule(SecurityConfiguration securityConfig) {
                return new TestSecurityModule();
            }
        }
    }
}

