/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.state.JavaSerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaSerializerTest
extends SerializerTestBase<Serializable> {
    private static final ClassLoader CLASS_LOADER = new URLClassLoader(new URL[0], JavaSerializerTest.class.getClassLoader());
    private static final Serializable OBJECT_OUT_OF_CLASSPATH = CommonTestUtils.createObjectForClassNotInClassPath((ClassLoader)CLASS_LOADER);
    private ClassLoader originalClassLoader;

    @Before
    public void setupClassLoader() {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CLASS_LOADER);
    }

    @After
    public void restoreOriginalClassLoader() {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
    }

    @Test
    public void guardTest() {
        try {
            Class.forName(OBJECT_OUT_OF_CLASSPATH.getClass().getName());
            Assert.fail((String)"Test ineffective: The test class that should not be on the classpath is actually on the classpath.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected TypeSerializer<Serializable> createSerializer() {
        Thread.currentThread().setContextClassLoader(CLASS_LOADER);
        return new JavaSerializer();
    }

    protected int getLength() {
        return -1;
    }

    protected Class<Serializable> getTypeClass() {
        return Serializable.class;
    }

    protected Serializable[] getTestData() {
        return new Serializable[]{new Integer(42), new File("/some/path/that/I/made/up"), OBJECT_OUT_OF_CLASSPATH, new Tuple1((Object)OBJECT_OUT_OF_CLASSPATH)};
    }

    public void testInstantiate() {
    }
}

