/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.runtime.testutils.statemigration.TestType;
import org.junit.Assert;
import org.junit.Test;

public class StateSerializerProviderTest {
    @Test
    public void testCurrentSchemaSerializerForNewStateSerializerProvider() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewState((TypeSerializer)new TestType.V1TestTypeSerializer());
        Assert.assertTrue((boolean)(testProvider.currentSchemaSerializer() instanceof TestType.V1TestTypeSerializer));
    }

    @Test
    public void testCurrentSchemaSerializerForRestoredStateSerializerProvider() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromRestoredState(serializer.snapshotConfiguration());
        Assert.assertTrue((boolean)(testProvider.currentSchemaSerializer() instanceof TestType.V1TestTypeSerializer));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPreviousSchemaSerializerForNewStateSerializerProvider() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewState((TypeSerializer)new TestType.V1TestTypeSerializer());
        testProvider.previousSchemaSerializer();
    }

    @Test
    public void testPreviousSchemaSerializerForRestoredStateSerializerProvider() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromRestoredState(serializer.snapshotConfiguration());
        Assert.assertTrue((boolean)(testProvider.previousSchemaSerializer() instanceof TestType.V1TestTypeSerializer));
    }

    @Test
    public void testLazyInstantiationOfPreviousSchemaSerializer() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromRestoredState((TypeSerializerSnapshot)new ExceptionThrowingSerializerSnapshot());
        try {
            testProvider.previousSchemaSerializer();
            Assert.fail((String)"expected to fail when accessing the restore serializer.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRegisterNewSerializerWithNewStateSerializerProviderShouldFail() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewState((TypeSerializer)new TestType.V1TestTypeSerializer());
        testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.V2TestTypeSerializer());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRegisterNewSerializerTwiceWithNewStateSerializerProviderShouldFail() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromRestoredState(serializer.snapshotConfiguration());
        testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.V2TestTypeSerializer());
        testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.V2TestTypeSerializer());
    }

    @Test
    public void testRegisterNewCompatibleAsIsSerializer() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromRestoredState(serializer.snapshotConfiguration());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.V1TestTypeSerializer());
        Assert.assertTrue((boolean)schemaCompatibility.isCompatibleAsIs());
        Assert.assertTrue((boolean)(testProvider.currentSchemaSerializer() instanceof TestType.V1TestTypeSerializer));
        Assert.assertTrue((boolean)(testProvider.previousSchemaSerializer() instanceof TestType.V1TestTypeSerializer));
    }

    @Test
    public void testRegisterNewCompatibleAfterMigrationSerializer() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromRestoredState(serializer.snapshotConfiguration());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.V2TestTypeSerializer());
        Assert.assertTrue((boolean)schemaCompatibility.isCompatibleAfterMigration());
    }

    @Test
    public void testRegisterIncompatibleSerializer() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromRestoredState(serializer.snapshotConfiguration());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.IncompatibleTestTypeSerializer());
        Assert.assertTrue((boolean)schemaCompatibility.isIncompatible());
        try {
            testProvider.currentSchemaSerializer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class ExceptionThrowingSerializerSnapshot
    implements TypeSerializerSnapshot<String> {
        public TypeSerializer<String> restoreSerializer() {
            throw new UnsupportedOperationException();
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            throw new UnsupportedOperationException();
        }

        public TypeSerializerSchemaCompatibility<String> resolveSchemaCompatibility(TypeSerializer<String> newSerializer) {
            throw new UnsupportedOperationException();
        }

        public int getCurrentVersion() {
            throw new UnsupportedOperationException();
        }
    }
}

