/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.runtime.state.ttl.TtlListState;
import org.apache.flink.runtime.state.ttl.TtlMergingStateTestContext;

class TtlListStateTestContext
extends TtlMergingStateTestContext<TtlListState<?, String, Integer>, List<Integer>, Iterable<Integer>> {
    TtlListStateTestContext() {
    }

    @Override
    void initTestValues() {
        this.emptyValue = Collections.emptyList();
        this.updateEmpty = Arrays.asList(5, 7, 10);
        this.updateUnexpired = Arrays.asList(8, 9, 11);
        this.updateExpired = Arrays.asList(1, 4);
        this.getUpdateEmpty = this.updateEmpty;
        this.getUnexpired = this.updateUnexpired;
        this.getUpdateExpired = this.updateExpired;
    }

    @Override
    void update(List<Integer> value) throws Exception {
        ((TtlListState)this.ttlState).addAll(value);
    }

    @Override
    Iterable<Integer> get() throws Exception {
        return StreamSupport.stream(((TtlListState)this.ttlState).get().spliterator(), false).collect(Collectors.toList());
    }

    @Override
    Object getOriginal() throws Exception {
        return ((InternalListState)((TtlListState)this.ttlState).original).get() == null ? this.emptyValue : ((InternalListState)((TtlListState)this.ttlState).original).get();
    }

    @Override
    <US extends State, SV> StateDescriptor<US, SV> createStateDescriptor() {
        return new ListStateDescriptor("TtlTestListState", (TypeSerializer)IntSerializer.INSTANCE);
    }

    @Override
    List<Integer> generateRandomUpdate() {
        int size = RANDOM.nextInt(5);
        return IntStream.range(0, size).mapToObj(i -> RANDOM.nextInt(100)).collect(Collectors.toList());
    }

    @Override
    Iterable<Integer> getMergeResult(List<Tuple2<String, List<Integer>>> unexpiredUpdatesToMerge, List<Tuple2<String, List<Integer>>> finalUpdatesToMerge) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        finalUpdatesToMerge.forEach(t -> result.addAll((Collection)t.f1));
        return result;
    }
}

