/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.internal.InternalReducingState;
import org.apache.flink.runtime.state.ttl.TtlMergingStateTestContext;
import org.apache.flink.runtime.state.ttl.TtlReducingState;

class TtlReducingStateTestContext
extends TtlMergingStateTestContext.TtlIntegerMergingStateTestContext<TtlReducingState<?, String, Integer>, Integer, Integer> {
    private static final ReduceFunction<Integer> REDUCE = (ReduceFunction & Serializable)(v1, v2) -> {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        return v1 + v2;
    };

    TtlReducingStateTestContext() {
    }

    @Override
    void initTestValues() {
        this.updateEmpty = 5;
        this.updateUnexpired = 7;
        this.updateExpired = 6;
        this.getUpdateEmpty = 5;
        this.getUnexpired = 12;
        this.getUpdateExpired = 6;
    }

    @Override
    <US extends State, SV> StateDescriptor<US, SV> createStateDescriptor() {
        return new ReducingStateDescriptor("TtlTestReducingState", REDUCE, (TypeSerializer)IntSerializer.INSTANCE);
    }

    @Override
    void update(Integer value) throws Exception {
        ((TtlReducingState)this.ttlState).add((Object)value);
    }

    @Override
    Integer get() throws Exception {
        return (Integer)((TtlReducingState)this.ttlState).get();
    }

    @Override
    Object getOriginal() throws Exception {
        return ((InternalReducingState)((TtlReducingState)this.ttlState).original).get();
    }

    @Override
    Integer getMergeResult(List<Tuple2<String, Integer>> unexpiredUpdatesToMerge, List<Tuple2<String, Integer>> finalUpdatesToMerge) {
        return this.getIntegerMergeResult(unexpiredUpdatesToMerge, finalUpdatesToMerge);
    }
}

