/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.net.InetAddress;
import java.util.Optional;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.taskexecutor.QueryableStateConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.runtime.taskmanager.NetworkEnvironmentConfiguration;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class NetworkBufferCalculationTest
extends TestLogger {
    @Test
    public void calculateNetworkBufFromHeapSize() throws Exception {
        TaskManagerServicesConfiguration tmConfig = NetworkBufferCalculationTest.getTmConfig(Long.valueOf((String)TaskManagerOptions.MANAGED_MEMORY_SIZE.defaultValue()), ((Float)TaskManagerOptions.MANAGED_MEMORY_FRACTION.defaultValue()).floatValue(), 0.1f, 0x3C00000L, 0x40000000L, MemoryType.HEAP);
        Assert.assertEquals((long)104857601L, (long)TaskManagerServices.calculateNetworkBufferMemory((TaskManagerServicesConfiguration)tmConfig, (long)943718400L));
        tmConfig = NetworkBufferCalculationTest.getTmConfig(Long.valueOf((String)TaskManagerOptions.MANAGED_MEMORY_SIZE.defaultValue()), ((Float)TaskManagerOptions.MANAGED_MEMORY_FRACTION.defaultValue()).floatValue(), 0.2f, 0x3C00000L, 0x40000000L, MemoryType.HEAP);
        Assert.assertEquals((long)209715203L, (long)TaskManagerServices.calculateNetworkBufferMemory((TaskManagerServicesConfiguration)tmConfig, (long)0x32000000L));
        tmConfig = NetworkBufferCalculationTest.getTmConfig(10L, ((Float)TaskManagerOptions.MANAGED_MEMORY_FRACTION.defaultValue()).floatValue(), 0.1f, 0x3C00000L, 0x40000000L, MemoryType.OFF_HEAP);
        Assert.assertEquals((long)104857601L, (long)TaskManagerServices.calculateNetworkBufferMemory((TaskManagerServicesConfiguration)tmConfig, (long)933232640L));
        tmConfig = NetworkBufferCalculationTest.getTmConfig(-1L, 0.1f, 0.1f, 0x3C00000L, 0x40000000L, MemoryType.OFF_HEAP);
        Assert.assertEquals((long)104857601L, (long)TaskManagerServices.calculateNetworkBufferMemory((TaskManagerServicesConfiguration)tmConfig, (long)849346560L));
    }

    private static TaskManagerServicesConfiguration getTmConfig(long managedMemory, float managedMemoryFraction, float networkBufFraction, long networkBufMin, long networkBufMax, MemoryType memType) {
        NetworkEnvironmentConfiguration networkConfig = new NetworkEnvironmentConfiguration(networkBufFraction, networkBufMin, networkBufMax, MathUtils.checkedDownCast((long)MemorySize.parse((String)((String)TaskManagerOptions.MEMORY_SEGMENT_SIZE.defaultValue())).getBytes()), null, ((Integer)TaskManagerOptions.NETWORK_REQUEST_BACKOFF_INITIAL.defaultValue()).intValue(), ((Integer)TaskManagerOptions.NETWORK_REQUEST_BACKOFF_MAX.defaultValue()).intValue(), ((Integer)TaskManagerOptions.NETWORK_BUFFERS_PER_CHANNEL.defaultValue()).intValue(), ((Integer)TaskManagerOptions.NETWORK_EXTRA_BUFFERS_PER_GATE.defaultValue()).intValue(), null);
        return new TaskManagerServicesConfiguration(InetAddress.getLoopbackAddress(), new String[0], new String[0], false, networkConfig, QueryableStateConfiguration.disabled(), 1, managedMemory, memType, false, managedMemoryFraction, 0L, Optional.empty());
    }
}

