/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.net.ServerSocket;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TaskManagerRunnerTest
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskManagerRunnerShutdown() throws Exception {
        Configuration configuration = new Configuration();
        ResourceID taskManagerResourceId = ResourceID.generate();
        ServerSocket localhost = new ServerSocket(0);
        configuration.setString(JobManagerOptions.ADDRESS, localhost.getInetAddress().getHostName());
        configuration.setInteger(JobManagerOptions.PORT, localhost.getLocalPort());
        configuration.setString(TaskManagerOptions.REGISTRATION_TIMEOUT, "10 ms");
        CompletableFuture<Void> jvmTerminationFuture = new CompletableFuture<Void>();
        TestingTaskManagerRunner taskManagerRunner = new TestingTaskManagerRunner(configuration, taskManagerResourceId, jvmTerminationFuture);
        taskManagerRunner.start();
        try {
            jvmTerminationFuture.get();
            Assert.assertThat((Object)taskManagerRunner.getTerminationFuture().isDone(), (Matcher)Matchers.is((Object)true));
        }
        finally {
            localhost.close();
            taskManagerRunner.close();
        }
    }

    private static class TestingTaskManagerRunner
    extends TaskManagerRunner {
        private final CompletableFuture<Void> jvmTerminationFuture;

        public TestingTaskManagerRunner(Configuration configuration, ResourceID resourceId, CompletableFuture<Void> jvmTerminationFuture) throws Exception {
            super(configuration, resourceId);
            this.jvmTerminationFuture = jvmTerminationFuture;
        }

        protected void terminateJVM() {
            this.jvmTerminationFuture.complete(null);
        }
    }
}

