/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.state.TaskExecutorLocalStateStoresManager;
import org.apache.flink.runtime.taskexecutor.JobLeaderService;
import org.apache.flink.runtime.taskexecutor.JobManagerTable;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.mockito.Mockito;

public class TaskManagerServicesBuilder {
    private TaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
    private MemoryManager memoryManager = new MemoryManager(4096L, 1, 4096, MemoryType.HEAP, false);
    private IOManager ioManager = (IOManager)Mockito.mock(IOManager.class);
    private NetworkEnvironment networkEnvironment = (NetworkEnvironment)Mockito.mock(NetworkEnvironment.class);
    private BroadcastVariableManager broadcastVariableManager = new BroadcastVariableManager();
    private TaskSlotTable taskSlotTable = (TaskSlotTable)Mockito.mock(TaskSlotTable.class);
    private JobManagerTable jobManagerTable = new JobManagerTable();
    private JobLeaderService jobLeaderService = new JobLeaderService(this.taskManagerLocation);
    private TaskExecutorLocalStateStoresManager taskStateManager = (TaskExecutorLocalStateStoresManager)Mockito.mock(TaskExecutorLocalStateStoresManager.class);

    public TaskManagerServicesBuilder setTaskManagerLocation(TaskManagerLocation taskManagerLocation) {
        this.taskManagerLocation = taskManagerLocation;
        return this;
    }

    public TaskManagerServicesBuilder setMemoryManager(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
        return this;
    }

    public TaskManagerServicesBuilder setIoManager(IOManager ioManager) {
        this.ioManager = ioManager;
        return this;
    }

    public TaskManagerServicesBuilder setNetworkEnvironment(NetworkEnvironment networkEnvironment) {
        this.networkEnvironment = networkEnvironment;
        return this;
    }

    public TaskManagerServicesBuilder setBroadcastVariableManager(BroadcastVariableManager broadcastVariableManager) {
        this.broadcastVariableManager = broadcastVariableManager;
        return this;
    }

    public TaskManagerServicesBuilder setTaskSlotTable(TaskSlotTable taskSlotTable) {
        this.taskSlotTable = taskSlotTable;
        return this;
    }

    public TaskManagerServicesBuilder setJobManagerTable(JobManagerTable jobManagerTable) {
        this.jobManagerTable = jobManagerTable;
        return this;
    }

    public TaskManagerServicesBuilder setJobLeaderService(JobLeaderService jobLeaderService) {
        this.jobLeaderService = jobLeaderService;
        return this;
    }

    public TaskManagerServicesBuilder setTaskStateManager(TaskExecutorLocalStateStoresManager taskStateManager) {
        this.taskStateManager = taskStateManager;
        return this;
    }

    public TaskManagerServices build() {
        return new TaskManagerServices(this.taskManagerLocation, this.memoryManager, this.ioManager, this.networkEnvironment, this.broadcastVariableManager, this.taskSlotTable, this.jobManagerTable, this.jobLeaderService, this.taskStateManager);
    }
}

