/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.Random;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class TaskManagerServicesTest
extends TestLogger {
    @Test
    public void calculateNetworkBufOld() {
        Configuration config = new Configuration();
        config.setInteger(TaskManagerOptions.NETWORK_NUM_BUFFERS, 1);
        Assert.assertEquals((long)MemorySize.parse((String)((String)TaskManagerOptions.MEMORY_SEGMENT_SIZE.defaultValue())).getBytes(), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0xA00000L, (Configuration)config));
        Assert.assertEquals((long)MemorySize.parse((String)((String)TaskManagerOptions.MEMORY_SEGMENT_SIZE.defaultValue())).getBytes(), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x4000000L, (Configuration)config));
        int numBuffers = (int)(0x200000000L / MemorySize.parse((String)((String)TaskManagerOptions.MEMORY_SEGMENT_SIZE.defaultValue())).getBytes());
        config.setInteger(TaskManagerOptions.NETWORK_NUM_BUFFERS, numBuffers);
        Assert.assertEquals((long)0x200000000L, (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x400000000L, (Configuration)config));
    }

    @Test
    public void calculateNetworkBufNew() throws Exception {
        Configuration config = new Configuration();
        Float defaultFrac = (Float)TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION.defaultValue();
        Long defaultMin = MemorySize.parse((String)((String)TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN.defaultValue())).getBytes();
        Long defaultMax = MemorySize.parse((String)((String)TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX.defaultValue())).getBytes();
        Assert.assertEquals((long)TaskManagerServicesTest.enforceBounds((long)(defaultFrac.floatValue() * 1.048576E7f), defaultMin, defaultMax), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x8000000L, (Configuration)config));
        Assert.assertEquals((long)TaskManagerServicesTest.enforceBounds((long)(defaultFrac.floatValue() * 1.0737418E10f), defaultMin, defaultMax), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x280000000L, (Configuration)config));
        TaskManagerServicesTest.calculateNetworkBufNew(config);
    }

    private static void calculateNetworkBufNew(Configuration config) {
        config.setString(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN, String.valueOf(0x100000L));
        config.setString(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX, String.valueOf(0x100000L));
        Assert.assertEquals((long)0x100000L, (long)TaskManagerServices.calculateNetworkBufferMemory((long)0xA00000L, (Configuration)config));
        Assert.assertEquals((long)0x100000L, (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x4000000L, (Configuration)config));
        Assert.assertEquals((long)0x100000L, (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x40000000L, (Configuration)config));
        Random ran = new Random();
        for (int i = 0; i < 1000; ++i) {
            float frac = Math.max(ran.nextFloat(), Float.MIN_VALUE);
            config.setFloat(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION, frac);
            long min = Math.max(MemorySize.parse((String)((String)TaskManagerOptions.MEMORY_SEGMENT_SIZE.defaultValue())).getBytes(), ran.nextLong());
            config.setString(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN, String.valueOf(min));
            long max = Math.max(min, ran.nextLong());
            config.setString(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX, String.valueOf(max));
            long javaMem = Math.max(max + 1L, ran.nextLong());
            long networkBufMem = TaskManagerServices.calculateNetworkBufferMemory((long)javaMem, (Configuration)config);
            if (networkBufMem < min) {
                Assert.fail((String)("Lower bound not met with configuration: " + config.toString()));
            }
            if (networkBufMem > max) {
                Assert.fail((String)("Upper bound not met with configuration: " + config.toString()));
            }
            if (networkBufMem <= min || networkBufMem >= max || (float)javaMem * frac == (float)networkBufMem) continue;
            Assert.fail((String)("Wrong network buffer memory size with configuration: " + config.toString() + ". Expected value: " + (float)javaMem * frac + " actual value: " + networkBufMem + '.'));
        }
    }

    @Test
    public void calculateNetworkBufMixed() throws Exception {
        Configuration config = new Configuration();
        config.setInteger(TaskManagerOptions.NETWORK_NUM_BUFFERS, 1);
        Float defaultFrac = (Float)TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION.defaultValue();
        Long defaultMin = MemorySize.parse((String)((String)TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN.defaultValue())).getBytes();
        Long defaultMax = MemorySize.parse((String)((String)TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX.defaultValue())).getBytes();
        Configuration config1 = config.clone();
        config1.setFloat(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION, 0.1f);
        Assert.assertEquals((long)TaskManagerServicesTest.enforceBounds(0x100000L, defaultMin, defaultMax), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x8000000L, (Configuration)config1));
        Assert.assertEquals((long)TaskManagerServicesTest.enforceBounds(0x40000000L, defaultMin, defaultMax), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x280000000L, (Configuration)config1));
        config1 = config.clone();
        long newMin = MemorySize.parse((String)((String)TaskManagerOptions.MEMORY_SEGMENT_SIZE.defaultValue())).getBytes();
        config1.setString(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN, String.valueOf(newMin));
        Assert.assertEquals((long)TaskManagerServicesTest.enforceBounds((long)(defaultFrac.floatValue() * 1.048576E7f), newMin, defaultMax), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0xA00000L, (Configuration)config1));
        Assert.assertEquals((long)TaskManagerServicesTest.enforceBounds((long)(defaultFrac.floatValue() * 1.0737418E10f), newMin, defaultMax), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x280000000L, (Configuration)config1));
        config1 = config.clone();
        long newMax = Math.max(0x8000000L, MemorySize.parse((String)((String)TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN.defaultValue())).getBytes());
        config1.setString(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX, String.valueOf(newMax));
        Assert.assertEquals((long)TaskManagerServicesTest.enforceBounds((long)(defaultFrac.floatValue() * 1.048576E7f), defaultMin, newMax), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x8000000L, (Configuration)config1));
        Assert.assertEquals((long)TaskManagerServicesTest.enforceBounds((long)(defaultFrac.floatValue() * 1.0737418E10f), defaultMin, newMax), (long)TaskManagerServices.calculateNetworkBufferMemory((long)0x280000000L, (Configuration)config1));
        Assert.assertTrue((boolean)TaskManagerServicesConfiguration.hasNewNetworkBufConf((Configuration)config1));
        TaskManagerServicesTest.calculateNetworkBufNew(config);
    }

    private static long enforceBounds(long value, long lower, long upper) {
        return Math.min(upper, Math.max(lower, value));
    }

    @Test
    public void calculateHeapSizeMB() throws Exception {
        Configuration config = new Configuration();
        config.setFloat(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION, 0.1f);
        config.setString(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN, String.valueOf(0x4000000L));
        config.setString(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX, String.valueOf(0x40000000L));
        config.setBoolean(TaskManagerOptions.MEMORY_OFF_HEAP, false);
        Assert.assertEquals((long)900L, (long)TaskManagerServices.calculateHeapSizeMB((long)1000L, (Configuration)config));
        config.setBoolean(TaskManagerOptions.MEMORY_OFF_HEAP, false);
        config.setFloat(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION, 0.2f);
        Assert.assertEquals((long)800L, (long)TaskManagerServices.calculateHeapSizeMB((long)1000L, (Configuration)config));
        config.setBoolean(TaskManagerOptions.MEMORY_OFF_HEAP, true);
        config.setFloat(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION, 0.1f);
        config.setString(TaskManagerOptions.MANAGED_MEMORY_SIZE, "10m");
        Assert.assertEquals((long)890L, (long)TaskManagerServices.calculateHeapSizeMB((long)1000L, (Configuration)config));
        config.setString(TaskManagerOptions.MANAGED_MEMORY_SIZE, "0");
        config.setFloat(TaskManagerOptions.MANAGED_MEMORY_FRACTION, 0.1f);
        Assert.assertEquals((long)810L, (long)TaskManagerServices.calculateHeapSizeMB((long)1000L, (Configuration)config));
    }
}

