/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.BaseTestingActorGateway;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProviderException;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.taskmanager.TaskInputSplitProvider;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class TaskInputSplitProviderTest {
    @Test
    public void testRequestNextInputSplitWithInvalidExecutionID() throws InputSplitProviderException {
        NullInputSplitGateway gateway = new NullInputSplitGateway();
        JobID jobID = new JobID();
        JobVertexID vertexID = new JobVertexID();
        ExecutionAttemptID executionID = new ExecutionAttemptID();
        FiniteDuration timeout = new FiniteDuration(10L, TimeUnit.SECONDS);
        TaskInputSplitProvider provider = new TaskInputSplitProvider((ActorGateway)gateway, jobID, vertexID, executionID, timeout);
        InputSplit nextInputSplit = provider.getNextInputSplit(this.getClass().getClassLoader());
        Assert.assertTrue((nextInputSplit == null ? 1 : 0) != 0);
    }

    public static class NullInputSplitGateway
    extends BaseTestingActorGateway {
        private static final long serialVersionUID = -7733997150554492926L;

        public NullInputSplitGateway() {
            super((ExecutionContext)TestingUtils.defaultExecutionContext());
        }

        @Override
        public Object handleMessage(Object message) throws Exception {
            if (message instanceof JobManagerMessages.RequestNextInputSplit) {
                return new JobManagerMessages.NextInputSplit(null);
            }
            throw new Exception("Invalid message type");
        }
    }
}

