/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Kill;
import akka.actor.Props;
import akka.testkit.JavaTestKit;
import java.net.InetAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.FlinkResourceManager;
import org.apache.flink.runtime.clusterframework.standalone.StandaloneResourceManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedHaServices;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.messages.TaskManagerMessages;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.NoOpMetricRegistry;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.state.TaskExecutorLocalStateStoresManager;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskmanager.NetworkEnvironmentConfiguration;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import scala.Option;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class TaskManagerComponentsStartupShutdownTest
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComponentsStartupShutdown() throws Exception {
        Time timeout = Time.seconds((long)100L);
        int BUFFER_SIZE = 32768;
        Configuration config = new Configuration();
        config.setString(AkkaOptions.WATCH_HEARTBEAT_INTERVAL, "200 ms");
        config.setString(AkkaOptions.WATCH_HEARTBEAT_PAUSE, "1 s");
        config.setInteger(AkkaOptions.WATCH_THRESHOLD, 1);
        String[] TMP_DIR = ConfigurationUtils.parseTempDirectories((Configuration)config);
        ActorSystem actorSystem = null;
        EmbeddedHaServices highAvailabilityServices = new EmbeddedHaServices((Executor)TestingUtils.defaultExecutor());
        ActorRef jobManager = null;
        ActorRef taskManager = null;
        try {
            actorSystem = AkkaUtils.createLocalActorSystem((Configuration)config);
            jobManager = (ActorRef)JobManager.startJobManagerActors((Configuration)config, (ActorSystem)actorSystem, (ScheduledExecutorService)TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), (HighAvailabilityServices)highAvailabilityServices, (MetricRegistry)NoOpMetricRegistry.INSTANCE, (Option)Option.empty(), JobManager.class, MemoryArchivist.class)._1();
            FlinkResourceManager.startResourceManagerActors((Configuration)config, (ActorSystem)actorSystem, (LeaderRetrievalService)highAvailabilityServices.getJobManagerLeaderRetriever(HighAvailabilityServices.DEFAULT_JOB_ID), StandaloneResourceManager.class);
            boolean numberOfSlots = true;
            TaskManagerConfiguration tmConfig = new TaskManagerConfiguration(1, TMP_DIR, timeout, null, Time.milliseconds((long)500L), Time.seconds((long)30L), Time.seconds((long)10L), config, false, FlinkUserCodeClassLoaders.ResolveOrder.CHILD_FIRST, new String[0], null, null);
            int networkBufNum = 32;
            NetworkEnvironmentConfiguration netConf = new NetworkEnvironmentConfiguration(0.1f, 0x100000L, 0x100000L, 32768, IOManager.IOMode.SYNC, 0, 0, 2, 8, null);
            ResourceID taskManagerId = ResourceID.generate();
            TaskManagerLocation connectionInfo = new TaskManagerLocation(taskManagerId, InetAddress.getLocalHost(), 10000);
            MemoryManager memManager = new MemoryManager(0x100000L, 1, 32768, MemoryType.HEAP, false);
            IOManagerAsync ioManager = new IOManagerAsync(TMP_DIR);
            NetworkEnvironment network = new NetworkEnvironment(32, netConf.networkBufferSize(), netConf.partitionRequestInitialBackoff(), netConf.partitionRequestMaxBackoff(), netConf.networkBuffersPerChannel(), netConf.floatingNetworkBuffersPerGate(), true);
            network.start();
            TaskExecutorLocalStateStoresManager storesManager = new TaskExecutorLocalStateStoresManager(false, ioManager.getSpillingDirectories(), Executors.directExecutor());
            MetricRegistryConfiguration metricRegistryConfiguration = MetricRegistryConfiguration.fromConfiguration((Configuration)config);
            Props tmProps = Props.create(TaskManager.class, (Object[])new Object[]{tmConfig, taskManagerId, connectionInfo, memManager, ioManager, network, storesManager, 1, highAvailabilityServices, new TaskManagerMetricGroup(NoOpMetricRegistry.INSTANCE, connectionInfo.getHostname(), connectionInfo.getResourceID().getResourceIdString())});
            final ActorRef finalTaskManager = taskManager = actorSystem.actorOf(tmProps);
            new JavaTestKit(actorSystem){
                {
                    super(x0);
                    new JavaTestKit.Within(new FiniteDuration(5000L, TimeUnit.SECONDS)){

                        protected void run() {
                            finalTaskManager.tell((Object)TaskManagerMessages.getNotifyWhenRegisteredAtJobManagerMessage(), this.getTestActor());
                            this.expectMsgClass(TaskManagerMessages.RegisteredAtJobManager.class);
                        }
                    };
                }
            };
            taskManager.tell((Object)Kill.getInstance(), ActorRef.noSender());
            jobManager.tell((Object)Kill.getInstance(), ActorRef.noSender());
            actorSystem.terminate();
            Await.ready((Awaitable)actorSystem.whenTerminated(), (Duration)Duration.Inf());
            actorSystem = null;
            Assert.assertTrue((boolean)network.isShutdown());
            Assert.assertTrue((boolean)ioManager.isProperlyShutDown());
            Assert.assertTrue((boolean)memManager.isShutdown());
        }
        finally {
            if (actorSystem != null) {
                actorSystem.terminate();
                Await.ready((Awaitable)actorSystem.whenTerminated(), (Duration)TestingUtils.TESTING_TIMEOUT());
            }
            highAvailabilityServices.closeAndCleanupAllData();
        }
    }
}

