/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.util.Preconditions;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class JobManagerActorTestUtils {
    public static void waitForJobStatus(JobID jobId, JobStatus expectedJobStatus, ActorGateway jobManager, FiniteDuration timeout) throws Exception {
        Preconditions.checkNotNull((Object)jobId, (String)"Job ID");
        Preconditions.checkNotNull((Object)expectedJobStatus, (String)"Expected job status");
        Preconditions.checkNotNull((Object)jobManager, (String)"Job manager");
        Preconditions.checkNotNull((Object)timeout, (String)"Timeout");
        Deadline deadline = timeout.fromNow();
        while (deadline.hasTimeLeft()) {
            JobManagerMessages.JobStatusResponse response = JobManagerActorTestUtils.requestJobStatus(jobId, jobManager, deadline.timeLeft());
            if (response instanceof JobManagerMessages.CurrentJobStatus) {
                JobStatus jobStatus = ((JobManagerMessages.CurrentJobStatus)response).status();
                if (jobStatus == expectedJobStatus) {
                    return;
                }
                if (!jobStatus.isGloballyTerminalState()) continue;
                throw new IllegalStateException("Job is in terminal state " + jobStatus + ", but was waiting for " + expectedJobStatus + ".");
            }
            if (response instanceof JobManagerMessages.JobNotFound) {
                Thread.sleep(Math.min(100L, deadline.timeLeft().toMillis()));
                continue;
            }
            throw new IllegalStateException("Unexpected response.");
        }
        throw new IllegalStateException("Job not found within deadline.");
    }

    public static JobManagerMessages.JobStatusResponse requestJobStatus(JobID jobId, ActorGateway jobManager, FiniteDuration timeout) throws Exception {
        Preconditions.checkNotNull((Object)jobId, (String)"Job ID");
        Preconditions.checkNotNull((Object)jobManager, (String)"Job manager");
        Preconditions.checkNotNull((Object)timeout, (String)"Timeout");
        JobManagerMessages.RequestJobStatus request = (JobManagerMessages.RequestJobStatus)JobManagerMessages.getRequestJobStatus((JobID)jobId);
        Future ask = jobManager.ask((Object)request, timeout);
        Object response = Await.result((Awaitable)ask, (Duration)timeout);
        if (response instanceof JobManagerMessages.JobStatusResponse) {
            return (JobManagerMessages.JobStatusResponse)response;
        }
        throw new IllegalStateException("Unexpected response.");
    }

    public static void waitForTaskManagers(int minimumNumberOfTaskManagers, ActorGateway jobManager, FiniteDuration timeout) throws Exception {
        Preconditions.checkArgument((minimumNumberOfTaskManagers >= 1 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)jobManager, (String)"Job manager");
        Preconditions.checkNotNull((Object)timeout, (String)"Timeout");
        Deadline deadline = timeout.fromNow();
        while (deadline.hasTimeLeft()) {
            Future ask = jobManager.ask(JobManagerMessages.getRequestNumberRegisteredTaskManager(), deadline.timeLeft());
            Integer response = (Integer)Await.result((Awaitable)ask, (Duration)deadline.timeLeft());
            if (response >= minimumNumberOfTaskManagers) {
                return;
            }
            Thread.sleep(Math.min(100L, deadline.timeLeft().toMillis()));
        }
        throw new IllegalStateException("Task managers not connected within deadline.");
    }
}

