/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import akka.actor.ActorRef;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.messages.RegisterResourceManagerSuccessful;
import org.apache.flink.runtime.clusterframework.standalone.StandaloneResourceManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.testingUtils.TestingMessages;
import org.apache.flink.runtime.testingUtils.TestingMessages$Alive$;
import org.apache.flink.runtime.testingUtils.TestingMessages$NotifyOfComponentShutdown$;

public class TestingResourceManager
extends StandaloneResourceManager {
    private Set<ActorRef> waitForResourceManagerConnected = new HashSet<ActorRef>();
    private Set<ActorRef> waitForShutdown = new HashSet<ActorRef>();
    private boolean isConnected = false;

    public TestingResourceManager(Configuration flinkConfig, LeaderRetrievalService leaderRetriever) {
        super(flinkConfig, leaderRetriever);
    }

    protected void handleMessage(Object message) {
        if (message instanceof GetRegisteredResources) {
            this.sender().tell((Object)new GetRegisteredResourcesReply(this.getStartedTaskManagers()), this.self());
        } else if (message instanceof FailResource) {
            ResourceID resourceID = ((FailResource)message).resourceID;
            this.notifyWorkerFailed(resourceID, "Failed for test case.");
        } else if (message instanceof NotifyWhenResourceManagerConnected) {
            if (this.isConnected) {
                this.sender().tell((Object)Acknowledge.get(), this.self());
            } else {
                this.waitForResourceManagerConnected.add(this.sender());
            }
        } else if (message instanceof RegisterResourceManagerSuccessful) {
            super.handleMessage(message);
            this.isConnected = true;
            for (ActorRef ref : this.waitForResourceManagerConnected) {
                ref.tell((Object)Acknowledge.get(), this.self());
            }
            this.waitForResourceManagerConnected.clear();
        } else if (message instanceof TestingMessages$NotifyOfComponentShutdown$) {
            this.waitForShutdown.add(this.sender());
        } else if (message instanceof TestingMessages$Alive$) {
            this.sender().tell((Object)Acknowledge.get(), this.self());
        } else {
            super.handleMessage(message);
        }
    }

    protected void shutdownApplication(ApplicationStatus finalStatus, String optionalDiagnostics) {
        for (ActorRef listener : this.waitForShutdown) {
            listener.tell((Object)new TestingMessages.ComponentShutdown(this.self()), this.self());
        }
        this.waitForShutdown.clear();
    }

    public static class NotifyWhenResourceManagerConnected {
    }

    public static class FailResource {
        public ResourceID resourceID;

        public FailResource(ResourceID resourceID) {
            this.resourceID = resourceID;
        }
    }

    public static class GetRegisteredResourcesReply {
        public Collection<ResourceID> resources;

        public GetRegisteredResourcesReply(Collection<ResourceID> resources) {
            this.resources = resources;
        }
    }

    public static class GetRegisteredResources {
    }
}

