/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.webmonitor.ClusterOverview;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.OperatorBackPressureStatsResponse;
import org.apache.flink.runtime.rpc.RpcTimeout;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;

public final class TestingDispatcherGateway
extends TestingRestfulGateway
implements DispatcherGateway {
    static final Function<JobGraph, CompletableFuture<Acknowledge>> DEFAULT_SUBMIT_FUNCTION = jobGraph -> CompletableFuture.completedFuture(Acknowledge.get());
    static final Supplier<CompletableFuture<Collection<JobID>>> DEFAULT_LIST_FUNCTION = () -> CompletableFuture.completedFuture(Collections.emptyList());
    static final int DEFAULT_BLOB_SERVER_PORT = 1234;
    static final DispatcherId DEFAULT_FENCING_TOKEN = DispatcherId.generate();
    static final Function<JobID, CompletableFuture<ArchivedExecutionGraph>> DEFAULT_REQUEST_ARCHIVED_JOB_FUNCTION = jobID -> CompletableFuture.completedFuture(null);
    private Function<JobGraph, CompletableFuture<Acknowledge>> submitFunction;
    private Supplier<CompletableFuture<Collection<JobID>>> listFunction;
    private int blobServerPort;
    private DispatcherId fencingToken;
    private Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestArchivedJobFunction;

    public TestingDispatcherGateway() {
        this.submitFunction = DEFAULT_SUBMIT_FUNCTION;
        this.listFunction = DEFAULT_LIST_FUNCTION;
        this.blobServerPort = 1234;
        this.fencingToken = DEFAULT_FENCING_TOKEN;
        this.requestArchivedJobFunction = DEFAULT_REQUEST_ARCHIVED_JOB_FUNCTION;
    }

    public TestingDispatcherGateway(String address, String hostname, String restAddress, Function<JobID, CompletableFuture<Acknowledge>> cancelJobFunction, Function<JobID, CompletableFuture<Acknowledge>> stopJobFunction, Function<JobID, CompletableFuture<? extends AccessExecutionGraph>> requestJobFunction, Function<JobID, CompletableFuture<JobResult>> requestJobResultFunction, Function<JobID, CompletableFuture<JobStatus>> requestJobStatusFunction, Supplier<CompletableFuture<MultipleJobsDetails>> requestMultipleJobDetailsSupplier, Supplier<CompletableFuture<ClusterOverview>> requestClusterOverviewSupplier, Supplier<CompletableFuture<Collection<String>>> requestMetricQueryServicePathsSupplier, Supplier<CompletableFuture<Collection<Tuple2<ResourceID, String>>>> requestTaskManagerMetricQueryServicePathsSupplier, BiFunction<JobID, JobVertexID, CompletableFuture<OperatorBackPressureStatsResponse>> requestOperatorBackPressureStatsFunction, BiFunction<JobID, String, CompletableFuture<String>> triggerSavepointFunction, Function<JobGraph, CompletableFuture<Acknowledge>> submitFunction, Supplier<CompletableFuture<Collection<JobID>>> listFunction, int blobServerPort, DispatcherId fencingToken, Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestArchivedJobFunction) {
        super(address, hostname, restAddress, cancelJobFunction, stopJobFunction, requestJobFunction, requestJobResultFunction, requestJobStatusFunction, requestMultipleJobDetailsSupplier, requestClusterOverviewSupplier, requestMetricQueryServicePathsSupplier, requestTaskManagerMetricQueryServicePathsSupplier, requestOperatorBackPressureStatsFunction, triggerSavepointFunction);
        this.submitFunction = submitFunction;
        this.listFunction = listFunction;
        this.blobServerPort = blobServerPort;
        this.fencingToken = fencingToken;
        this.requestArchivedJobFunction = requestArchivedJobFunction;
    }

    public CompletableFuture<Acknowledge> submitJob(JobGraph jobGraph, Time timeout) {
        return this.submitFunction.apply(jobGraph);
    }

    public CompletableFuture<Collection<JobID>> listJobs(Time timeout) {
        return this.listFunction.get();
    }

    public CompletableFuture<Integer> getBlobServerPort(Time timeout) {
        return CompletableFuture.completedFuture(this.blobServerPort);
    }

    public DispatcherId getFencingToken() {
        return DEFAULT_FENCING_TOKEN;
    }

    public CompletableFuture<ArchivedExecutionGraph> requestJob(JobID jobId, @RpcTimeout Time timeout) {
        return this.requestArchivedJobFunction.apply(jobId);
    }

    public static final class Builder
    extends TestingRestfulGateway.Builder {
        private Function<JobGraph, CompletableFuture<Acknowledge>> submitFunction;
        private Supplier<CompletableFuture<Collection<JobID>>> listFunction;
        private int blobServerPort;
        private DispatcherId fencingToken;
        private Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestArchivedJobFunction;

        public Builder setSubmitFunction(Function<JobGraph, CompletableFuture<Acknowledge>> submitFunction) {
            this.submitFunction = submitFunction;
            return this;
        }

        public Builder setListFunction(Supplier<CompletableFuture<Collection<JobID>>> listFunction) {
            this.listFunction = listFunction;
            return this;
        }

        public Builder setRequestArchivedJobFunction(Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestJobFunction) {
            this.requestArchivedJobFunction = requestJobFunction;
            return this;
        }

        @Override
        public TestingRestfulGateway.Builder setRequestJobFunction(Function<JobID, CompletableFuture<? extends AccessExecutionGraph>> requestJobFunction) {
            throw new UnsupportedOperationException("Use setRequestArchivedJobFunction() instead.");
        }

        public Builder setBlobServerPort(int blobServerPort) {
            this.blobServerPort = blobServerPort;
            return this;
        }

        public Builder setFencingToken(DispatcherId fencingToken) {
            this.fencingToken = fencingToken;
            return this;
        }

        @Override
        public TestingDispatcherGateway build() {
            return new TestingDispatcherGateway(this.address, this.hostname, this.restAddress, this.cancelJobFunction, this.stopJobFunction, this.requestJobFunction, this.requestJobResultFunction, this.requestJobStatusFunction, this.requestMultipleJobDetailsSupplier, this.requestClusterOverviewSupplier, this.requestMetricQueryServicePathsSupplier, this.requestTaskManagerMetricQueryServicePathsSupplier, this.requestOperatorBackPressureStatsFunction, this.triggerSavepointFunction, this.submitFunction, this.listFunction, this.blobServerPort, this.fencingToken, this.requestArchivedJobFunction);
        }
    }
}

