/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.retriever.impl;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.client.JobClientActorTest;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.webmonitor.retriever.impl.AkkaJobManagerRetriever;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;

public class AkkaJobManagerRetrieverTest
extends TestLogger {
    private static final Time timeout = Time.seconds((long)10L);
    private static ActorSystem actorSystem;

    @BeforeClass
    public static void setup() {
        actorSystem = AkkaUtils.createDefaultActorSystem();
    }

    @AfterClass
    public static void teardown() throws InterruptedException, TimeoutException {
        if (actorSystem != null) {
            actorSystem.terminate();
            Await.ready((Awaitable)actorSystem.whenTerminated(), (Duration)FutureUtils.toFiniteDuration((Time)timeout));
            actorSystem = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAkkaJobManagerRetrieval() throws Exception {
        AkkaJobManagerRetriever akkaJobManagerRetriever = new AkkaJobManagerRetriever(actorSystem, timeout, 0, Time.milliseconds((long)0L));
        SettableLeaderRetrievalService settableLeaderRetrievalService = new SettableLeaderRetrievalService();
        CompletableFuture gatewayFuture = akkaJobManagerRetriever.getFuture();
        UUID leaderSessionId = UUID.randomUUID();
        ActorRef actorRef = null;
        try {
            actorRef = actorSystem.actorOf(Props.create(JobClientActorTest.PlainActor.class, (Object[])new Object[]{leaderSessionId}));
            String address = actorRef.path().toString();
            settableLeaderRetrievalService.start((LeaderRetrievalListener)akkaJobManagerRetriever);
            Assert.assertFalse((boolean)gatewayFuture.isDone());
            settableLeaderRetrievalService.notifyListener(address, leaderSessionId);
            JobManagerGateway jobManagerGateway = (JobManagerGateway)gatewayFuture.get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)address, (Object)jobManagerGateway.getAddress());
        }
        catch (Throwable throwable) {
            settableLeaderRetrievalService.stop();
            if (actorRef != null) {
                TestingUtils.stopActorGracefully(actorRef);
            }
            throw throwable;
        }
        settableLeaderRetrievalService.stop();
        if (actorRef != null) {
            TestingUtils.stopActorGracefully(actorRef);
        }
    }
}

