/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.retriever.impl;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.runtime.rpc.FencedRpcGateway;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcTimeout;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.webmonitor.retriever.impl.RpcGatewayRetriever;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RpcGatewayRetrieverTest
extends TestLogger {
    private static final Time TIMEOUT = Time.seconds((long)10L);
    private static TestingRpcService rpcService;

    @BeforeClass
    public static void setup() {
        rpcService = new TestingRpcService();
    }

    @AfterClass
    public static void teardown() throws InterruptedException, ExecutionException, TimeoutException {
        if (rpcService != null) {
            RpcUtils.terminateRpcService((RpcService)rpcService, (Time)TIMEOUT);
            rpcService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRpcGatewayRetrieval() throws Exception {
        String expectedValue = "foobar";
        String expectedValue2 = "barfoo";
        UUID leaderSessionId = UUID.randomUUID();
        RpcGatewayRetriever gatewayRetriever = new RpcGatewayRetriever((RpcService)rpcService, DummyGateway.class, Function.identity(), 0, Time.milliseconds((long)0L));
        SettableLeaderRetrievalService settableLeaderRetrievalService = new SettableLeaderRetrievalService();
        DummyRpcEndpoint dummyRpcEndpoint = new DummyRpcEndpoint((RpcService)rpcService, "dummyRpcEndpoint1", "foobar");
        DummyRpcEndpoint dummyRpcEndpoint2 = new DummyRpcEndpoint((RpcService)rpcService, "dummyRpcEndpoint2", "barfoo");
        rpcService.registerGateway(dummyRpcEndpoint.getAddress(), dummyRpcEndpoint.getSelfGateway(DummyGateway.class));
        rpcService.registerGateway(dummyRpcEndpoint2.getAddress(), dummyRpcEndpoint2.getSelfGateway(DummyGateway.class));
        try {
            dummyRpcEndpoint.start();
            dummyRpcEndpoint2.start();
            settableLeaderRetrievalService.start((LeaderRetrievalListener)gatewayRetriever);
            CompletableFuture gatewayFuture = gatewayRetriever.getFuture();
            Assert.assertFalse((boolean)gatewayFuture.isDone());
            settableLeaderRetrievalService.notifyListener(dummyRpcEndpoint.getAddress(), leaderSessionId);
            DummyGateway dummyGateway = (DummyGateway)gatewayFuture.get(TIMEOUT.toMilliseconds(), TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)dummyRpcEndpoint.getAddress(), (Object)dummyGateway.getAddress());
            Assert.assertEquals((Object)"foobar", (Object)dummyGateway.foobar(TIMEOUT).get(TIMEOUT.toMilliseconds(), TimeUnit.MILLISECONDS));
            settableLeaderRetrievalService.notifyListener(dummyRpcEndpoint2.getAddress(), leaderSessionId);
            CompletableFuture gatewayFuture2 = gatewayRetriever.getFuture();
            DummyGateway dummyGateway2 = (DummyGateway)gatewayFuture2.get(TIMEOUT.toMilliseconds(), TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)dummyRpcEndpoint2.getAddress(), (Object)dummyGateway2.getAddress());
            Assert.assertEquals((Object)"barfoo", (Object)dummyGateway2.foobar(TIMEOUT).get(TIMEOUT.toMilliseconds(), TimeUnit.MILLISECONDS));
        }
        finally {
            dummyRpcEndpoint.shutDown();
            dummyRpcEndpoint2.shutDown();
            dummyRpcEndpoint.getTerminationFuture().get(TIMEOUT.toMilliseconds(), TimeUnit.MILLISECONDS);
            dummyRpcEndpoint2.getTerminationFuture().get(TIMEOUT.toMilliseconds(), TimeUnit.MILLISECONDS);
        }
    }

    static class DummyRpcEndpoint
    extends RpcEndpoint
    implements DummyGateway {
        private final String value;

        protected DummyRpcEndpoint(RpcService rpcService, String endpointId, String value) {
            super(rpcService, endpointId);
            this.value = value;
        }

        @Override
        public CompletableFuture<String> foobar(Time timeout) {
            return CompletableFuture.completedFuture(this.value);
        }

        public UUID getFencingToken() {
            return HighAvailabilityServices.DEFAULT_LEADER_ID;
        }

        public CompletableFuture<Void> postStop() {
            return CompletableFuture.completedFuture(null);
        }
    }

    public static interface DummyGateway
    extends FencedRpcGateway<UUID> {
        public CompletableFuture<String> foobar(@RpcTimeout Time var1);
    }
}

