/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.checkpoint;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.streaming.api.checkpoint.ListCheckpointed;
import org.apache.flink.streaming.api.operators.StreamMap;
import org.apache.flink.streaming.runtime.tasks.OperatorStateHandles;
import org.apache.flink.streaming.util.AbstractStreamOperatorTestHarness;
import org.junit.Assert;
import org.junit.Test;

public class ListCheckpointedTest {
    @Test
    public void testUDFReturningNull() throws Exception {
        TestUserFunction userFunction = new TestUserFunction(null);
        AbstractStreamOperatorTestHarness testHarness = new AbstractStreamOperatorTestHarness(new StreamMap((MapFunction)userFunction), 1, 1, 0);
        testHarness.open();
        OperatorStateHandles snapshot = testHarness.snapshot(0L, 0L);
        testHarness.initializeState(snapshot);
        Assert.assertTrue((boolean)userFunction.isRestored());
    }

    @Test
    public void testUDFReturningEmpty() throws Exception {
        TestUserFunction userFunction = new TestUserFunction(Collections.emptyList());
        AbstractStreamOperatorTestHarness testHarness = new AbstractStreamOperatorTestHarness(new StreamMap((MapFunction)userFunction), 1, 1, 0);
        testHarness.open();
        OperatorStateHandles snapshot = testHarness.snapshot(0L, 0L);
        testHarness.initializeState(snapshot);
        Assert.assertTrue((boolean)userFunction.isRestored());
    }

    @Test
    public void testUDFReturningData() throws Exception {
        TestUserFunction userFunction = new TestUserFunction(Arrays.asList(1, 2, 3));
        AbstractStreamOperatorTestHarness testHarness = new AbstractStreamOperatorTestHarness(new StreamMap((MapFunction)userFunction), 1, 1, 0);
        testHarness.open();
        OperatorStateHandles snapshot = testHarness.snapshot(0L, 0L);
        testHarness.initializeState(snapshot);
        Assert.assertTrue((boolean)userFunction.isRestored());
    }

    private static class TestUserFunction
    extends RichMapFunction<Integer, Integer>
    implements ListCheckpointed<Integer> {
        private static final long serialVersionUID = -8981369286399531925L;
        private final List<Integer> expected;
        private boolean restored;

        public TestUserFunction(List<Integer> expected) {
            this.expected = expected;
            this.restored = false;
        }

        public Integer map(Integer value) throws Exception {
            return value;
        }

        public List<Integer> snapshotState(long checkpointId, long timestamp) throws Exception {
            return this.expected;
        }

        public void restoreState(List<Integer> state) throws Exception {
            if (null != this.expected) {
                Assert.assertEquals(this.expected, state);
            } else {
                Assert.assertTrue((boolean)state.isEmpty());
            }
            this.restored = true;
        }

        public boolean isRestored() {
            return this.restored;
        }
    }
}

