/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.Flip6LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class LocalStreamEnvironmentITCase
extends TestLogger {
    @Test
    public void testRunIsolatedJob() throws Exception {
        Flip6LocalStreamEnvironment env = new Flip6LocalStreamEnvironment();
        Assert.assertEquals((long)1L, (long)env.getParallelism());
        LocalStreamEnvironmentITCase.addSmallBoundedJob((StreamExecutionEnvironment)env, 3);
        env.execute();
    }

    @Test
    public void testMultipleJobsAfterAnother() throws Exception {
        Flip6LocalStreamEnvironment env = new Flip6LocalStreamEnvironment();
        LocalStreamEnvironmentITCase.addSmallBoundedJob((StreamExecutionEnvironment)env, 3);
        env.execute();
        LocalStreamEnvironmentITCase.addSmallBoundedJob((StreamExecutionEnvironment)env, 5);
        env.execute();
    }

    private static void addSmallBoundedJob(StreamExecutionEnvironment env, int parallelism) {
        SingleOutputStreamOperator stream = env.generateSequence(1L, 100L).setParallelism(parallelism).slotSharingGroup("group_1");
        stream.filter((FilterFunction)new FilterFunction<Long>(){

            public boolean filter(Long value) {
                return false;
            }
        }).setParallelism(parallelism).startNewChain().slotSharingGroup("group_2").print().setParallelism(parallelism);
    }
}

