/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.PrintSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkContextUtil;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class PrintSinkFunctionTest {
    public PrintStream printStreamOriginal = System.out;
    private String line = System.lineSeparator();

    @Test
    public void testPrintSinkStdOut() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(baos);
        System.setOut(stream);
        StreamingRuntimeContext ctx = (StreamingRuntimeContext)Mockito.mock(StreamingRuntimeContext.class);
        PrintSinkFunction printSink = new PrintSinkFunction();
        printSink.setRuntimeContext((RuntimeContext)ctx);
        try {
            printSink.open(new Configuration());
        }
        catch (Exception e) {
            Assert.fail();
        }
        printSink.setTargetToStandardOut();
        printSink.invoke((Object)"hello world!", SinkContextUtil.forTimestamp((long)0L));
        Assert.assertEquals((Object)"Print to System.out", (Object)printSink.toString());
        Assert.assertEquals((Object)("hello world!" + this.line), (Object)baos.toString());
        printSink.close();
        stream.close();
    }

    @Test
    public void testPrintSinkStdErr() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(baos);
        System.setOut(stream);
        StreamingRuntimeContext ctx = (StreamingRuntimeContext)Mockito.mock(StreamingRuntimeContext.class);
        PrintSinkFunction printSink = new PrintSinkFunction();
        printSink.setRuntimeContext((RuntimeContext)ctx);
        try {
            printSink.open(new Configuration());
        }
        catch (Exception e) {
            Assert.fail();
        }
        printSink.setTargetToStandardErr();
        printSink.invoke((Object)"hello world!", SinkContextUtil.forTimestamp((long)0L));
        Assert.assertEquals((Object)"Print to System.err", (Object)printSink.toString());
        Assert.assertEquals((Object)("hello world!" + this.line), (Object)baos.toString());
        printSink.close();
        stream.close();
    }

    @Test
    public void testPrintSinkWithPrefix() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(baos);
        System.setOut(stream);
        StreamingRuntimeContext ctx = (StreamingRuntimeContext)Mockito.mock(StreamingRuntimeContext.class);
        Mockito.when((Object)ctx.getNumberOfParallelSubtasks()).thenReturn((Object)2);
        Mockito.when((Object)ctx.getIndexOfThisSubtask()).thenReturn((Object)1);
        PrintSinkFunction printSink = new PrintSinkFunction();
        printSink.setRuntimeContext((RuntimeContext)ctx);
        try {
            printSink.open(new Configuration());
        }
        catch (Exception e) {
            Assert.fail();
        }
        printSink.setTargetToStandardErr();
        printSink.invoke((Object)"hello world!", SinkContextUtil.forTimestamp((long)0L));
        Assert.assertEquals((Object)"Print to System.err", (Object)printSink.toString());
        Assert.assertEquals((Object)("2> hello world!" + this.line), (Object)baos.toString());
        printSink.close();
        stream.close();
    }

    @After
    public void restoreSystemOut() {
        System.setOut(this.printStreamOriginal);
    }
}

