/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.RunnableFuture;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.streaming.api.operators.OperatorSnapshotResult;
import org.apache.flink.util.TestLogger;
import org.junit.Test;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;

public class OperatorSnapshotResultTest
extends TestLogger {
    @Test
    public void testCancelAndCleanup() throws Exception {
        OperatorSnapshotResult operatorSnapshotResult = new OperatorSnapshotResult();
        operatorSnapshotResult.cancel();
        KeyedStateHandle keyedManagedStateHandle = (KeyedStateHandle)Mockito.mock(KeyedStateHandle.class);
        RunnableFuture keyedStateManagedFuture = (RunnableFuture)Mockito.mock(RunnableFuture.class);
        PowerMockito.when(keyedStateManagedFuture.get()).thenReturn((Object)keyedManagedStateHandle);
        KeyedStateHandle keyedRawStateHandle = (KeyedStateHandle)Mockito.mock(KeyedStateHandle.class);
        RunnableFuture keyedStateRawFuture = (RunnableFuture)Mockito.mock(RunnableFuture.class);
        PowerMockito.when(keyedStateRawFuture.get()).thenReturn((Object)keyedRawStateHandle);
        OperatorStateHandle operatorManagedStateHandle = (OperatorStateHandle)Mockito.mock(OperatorStateHandle.class);
        RunnableFuture operatorStateManagedFuture = (RunnableFuture)Mockito.mock(RunnableFuture.class);
        PowerMockito.when(operatorStateManagedFuture.get()).thenReturn((Object)operatorManagedStateHandle);
        OperatorStateHandle operatorRawStateHandle = (OperatorStateHandle)Mockito.mock(OperatorStateHandle.class);
        RunnableFuture operatorStateRawFuture = (RunnableFuture)Mockito.mock(RunnableFuture.class);
        PowerMockito.when(operatorStateRawFuture.get()).thenReturn((Object)operatorRawStateHandle);
        operatorSnapshotResult = new OperatorSnapshotResult(keyedStateManagedFuture, keyedStateRawFuture, operatorStateManagedFuture, operatorStateRawFuture);
        operatorSnapshotResult.cancel();
        ((RunnableFuture)Mockito.verify((Object)keyedStateManagedFuture)).cancel(true);
        ((RunnableFuture)Mockito.verify((Object)keyedStateRawFuture)).cancel(true);
        ((RunnableFuture)Mockito.verify((Object)operatorStateManagedFuture)).cancel(true);
        ((RunnableFuture)Mockito.verify((Object)operatorStateRawFuture)).cancel(true);
        ((KeyedStateHandle)Mockito.verify((Object)keyedManagedStateHandle)).discardState();
        ((KeyedStateHandle)Mockito.verify((Object)keyedRawStateHandle)).discardState();
        ((OperatorStateHandle)Mockito.verify((Object)operatorManagedStateHandle)).discardState();
        ((OperatorStateHandle)Mockito.verify((Object)operatorRawStateHandle)).discardState();
    }
}

