/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.checkpoint.ListCheckpointed;
import org.apache.flink.streaming.api.operators.StreamMap;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.OperatorStateHandles;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.junit.Assert;
import org.junit.Test;

public class WrappingFunctionSnapshotRestoreTest {
    @Test
    public void testSnapshotAndRestoreWrappedCheckpointedFunction() throws Exception {
        StreamMap operator = new StreamMap((MapFunction)new WrappingTestFun(new WrappingTestFun(new InnerTestFun())));
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(operator);
        testHarness.setup();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)5, 12L));
        OperatorStateHandles snapshot = testHarness.snapshot(0L, 0L);
        testHarness.close();
        InnerTestFun innerTestFun = new InnerTestFun();
        operator = new StreamMap((MapFunction)new WrappingTestFun(new WrappingTestFun(innerTestFun)));
        testHarness = new OneInputStreamOperatorTestHarness(operator);
        testHarness.setup();
        testHarness.initializeState(snapshot);
        testHarness.open();
        Assert.assertTrue((boolean)innerTestFun.wasRestored);
        testHarness.close();
    }

    @Test
    public void testSnapshotAndRestoreWrappedListCheckpointed() throws Exception {
        StreamMap operator = new StreamMap((MapFunction)new WrappingTestFun(new WrappingTestFun(new InnerTestFunList())));
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(operator);
        testHarness.setup();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)5, 12L));
        OperatorStateHandles snapshot = testHarness.snapshot(0L, 0L);
        testHarness.close();
        InnerTestFunList innerTestFun = new InnerTestFunList();
        operator = new StreamMap((MapFunction)new WrappingTestFun(new WrappingTestFun(innerTestFun)));
        testHarness = new OneInputStreamOperatorTestHarness(operator);
        testHarness.setup();
        testHarness.initializeState(snapshot);
        testHarness.open();
        Assert.assertTrue((boolean)innerTestFun.wasRestored);
        testHarness.close();
    }

    static class InnerTestFunList
    extends AbstractRichFunction
    implements MapFunction<Integer, Integer>,
    ListCheckpointed<Integer> {
        private static final long serialVersionUID = 1L;
        private boolean wasRestored = false;

        public List<Integer> snapshotState(long checkpointId, long timestamp) throws Exception {
            return Collections.singletonList(42);
        }

        public void restoreState(List<Integer> state) throws Exception {
            Assert.assertEquals((long)1L, (long)state.size());
            int val = state.get(0);
            Assert.assertEquals((long)42L, (long)val);
            this.wasRestored = true;
        }

        public Integer map(Integer value) throws Exception {
            return value;
        }
    }

    static class InnerTestFun
    extends AbstractRichFunction
    implements MapFunction<Integer, Integer>,
    CheckpointedFunction {
        private static final long serialVersionUID = 1L;
        private ListState<Integer> serializableListState;
        private boolean wasRestored = false;

        public void snapshotState(FunctionSnapshotContext context) throws Exception {
            if (!this.wasRestored) {
                this.serializableListState.add((Object)42);
            }
        }

        public void initializeState(FunctionInitializationContext context) throws Exception {
            this.serializableListState = context.getOperatorStateStore().getListState(new ListStateDescriptor("test-state", (TypeSerializer)IntSerializer.INSTANCE));
            if (context.isRestored()) {
                Iterator integers = ((Iterable)this.serializableListState.get()).iterator();
                int act = (Integer)integers.next();
                Assert.assertEquals((long)42L, (long)act);
                Assert.assertFalse((boolean)integers.hasNext());
                this.wasRestored = true;
            }
        }

        public Integer map(Integer value) throws Exception {
            return value;
        }
    }

    static class WrappingTestFun
    extends WrappingFunction<MapFunction<Integer, Integer>>
    implements MapFunction<Integer, Integer> {
        private static final long serialVersionUID = 1L;

        public WrappingTestFun(MapFunction<Integer, Integer> wrappedFunction) {
            super(wrappedFunction);
        }

        public Integer map(Integer value) throws Exception {
            return value;
        }
    }
}

