/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputGateListener;

public class MockInputGate
implements InputGate {
    private final int pageSize;
    private final int numChannels;
    private final Queue<BufferOrEvent> boes;
    private final boolean[] closed;
    private int closedChannels;

    public MockInputGate(int pageSize, int numChannels, List<BufferOrEvent> boes) {
        this.pageSize = pageSize;
        this.numChannels = numChannels;
        this.boes = new ArrayDeque<BufferOrEvent>(boes);
        this.closed = new boolean[numChannels];
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getNumberOfInputChannels() {
        return this.numChannels;
    }

    public boolean isFinished() {
        return this.boes.isEmpty();
    }

    public BufferOrEvent getNextBufferOrEvent() {
        BufferOrEvent next = this.boes.poll();
        if (next == null) {
            return null;
        }
        int channelIdx = next.getChannelIndex();
        if (this.closed[channelIdx]) {
            throw new RuntimeException("Inconsistent: Channel " + channelIdx + " has data even though it is already closed.");
        }
        if (next.isEvent() && next.getEvent() instanceof EndOfPartitionEvent) {
            this.closed[channelIdx] = true;
            ++this.closedChannels;
        }
        return next;
    }

    public void requestPartitions() {
    }

    public void sendTaskEvent(TaskEvent event) {
    }

    public void registerListener(InputGateListener listener) {
    }
}

