/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.runtime.operators.windowing.StreamRecordMatchers;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TumblingEventTimeWindowsTest
extends TestLogger {
    @Test
    public void testWindowAssignment() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingEventTimeWindows assigner = TumblingEventTimeWindows.of((Time)Time.milliseconds((long)5000L));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 0L, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(0L, 5000L)));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 4999L, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(0L, 5000L)));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 5000L, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(5000L, 10000L)));
    }

    @Test
    public void testWindowAssignmentWithOffset() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingEventTimeWindows assigner = TumblingEventTimeWindows.of((Time)Time.milliseconds((long)5000L), (Time)Time.milliseconds((long)100L));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 100L, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(100L, 5100L)));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 5099L, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(100L, 5100L)));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 5100L, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(5100L, 10100L)));
    }

    @Test
    public void testTimeUnits() {
        WindowAssigner.WindowAssignerContext mockContext = (WindowAssigner.WindowAssignerContext)Mockito.mock(WindowAssigner.WindowAssignerContext.class);
        TumblingEventTimeWindows assigner = TumblingEventTimeWindows.of((Time)Time.seconds((long)5L), (Time)Time.seconds((long)1L));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 1000L, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(1000L, 6000L)));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 5999L, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(1000L, 6000L)));
        Assert.assertThat((Object)assigner.assignWindows((Object)"String", 6000L, mockContext), (Matcher)Matchers.contains(StreamRecordMatchers.timeWindow(6000L, 11000L)));
    }

    @Test
    public void testInvalidParameters() {
        try {
            TumblingEventTimeWindows.of((Time)Time.seconds((long)-1L));
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"0 <= offset < size"));
        }
        try {
            TumblingEventTimeWindows.of((Time)Time.seconds((long)10L), (Time)Time.seconds((long)20L));
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"0 <= offset < size"));
        }
        try {
            TumblingEventTimeWindows.of((Time)Time.seconds((long)10L), (Time)Time.seconds((long)-1L));
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"0 <= offset < size"));
        }
    }

    @Test
    public void testProperties() {
        TumblingEventTimeWindows assigner = TumblingEventTimeWindows.of((Time)Time.seconds((long)5L), (Time)Time.milliseconds((long)100L));
        Assert.assertTrue((boolean)assigner.isEventTime());
        Assert.assertEquals((Object)new TimeWindow.Serializer(), (Object)assigner.getWindowSerializer(new ExecutionConfig()));
        Assert.assertThat((Object)assigner.getDefaultTrigger((StreamExecutionEnvironment)Mockito.mock(StreamExecutionEnvironment.class)), (Matcher)Matchers.instanceOf(EventTimeTrigger.class));
    }
}

