/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.RebalancePartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RebalancePartitionerTest {
    private RebalancePartitioner<Tuple> distributePartitioner;
    private StreamRecord<Tuple> streamRecord = new StreamRecord(null);
    private SerializationDelegate<StreamRecord<Tuple>> sd = new SerializationDelegate(null);

    @Before
    public void setPartitioner() {
        this.distributePartitioner = new RebalancePartitioner();
    }

    @Test
    public void testSelectChannelsLength() {
        this.sd.setInstance(this.streamRecord);
        Assert.assertEquals((long)1L, (long)this.distributePartitioner.selectChannels(this.sd, 1).length);
        Assert.assertEquals((long)1L, (long)this.distributePartitioner.selectChannels(this.sd, 2).length);
        Assert.assertEquals((long)1L, (long)this.distributePartitioner.selectChannels(this.sd, 1024).length);
    }

    @Test
    public void testSelectChannelsInterval() {
        this.sd.setInstance(this.streamRecord);
        Assert.assertEquals((long)0L, (long)this.distributePartitioner.selectChannels(this.sd, 3)[0]);
        Assert.assertEquals((long)1L, (long)this.distributePartitioner.selectChannels(this.sd, 3)[0]);
        Assert.assertEquals((long)2L, (long)this.distributePartitioner.selectChannels(this.sd, 3)[0]);
        Assert.assertEquals((long)0L, (long)this.distributePartitioner.selectChannels(this.sd, 3)[0]);
    }
}

