/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.io.IOException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.StreamTestSingleInputGate;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.streaming.runtime.tasks.OneInputStreamTask;
import org.apache.flink.streaming.runtime.tasks.StreamTaskTestHarness;

public class OneInputStreamTaskTestHarness<IN, OUT>
extends StreamTaskTestHarness<OUT> {
    private TypeInformation<IN> inputType;
    private TypeSerializer<IN> inputSerializer;

    public OneInputStreamTaskTestHarness(OneInputStreamTask<IN, OUT> task, int numInputGates, int numInputChannelsPerGate, TypeInformation<IN> inputType, TypeInformation<OUT> outputType) {
        super((AbstractInvokable)task, outputType);
        this.inputType = inputType;
        this.inputSerializer = inputType.createSerializer(this.executionConfig);
        this.numInputGates = numInputGates;
        this.numInputChannelsPerGate = numInputChannelsPerGate;
    }

    public OneInputStreamTaskTestHarness(OneInputStreamTask<IN, OUT> task, TypeInformation<IN> inputType, TypeInformation<OUT> outputType) {
        this(task, 1, 1, inputType, outputType);
    }

    @Override
    protected void initializeInputs() throws IOException, InterruptedException {
        this.inputGates = new StreamTestSingleInputGate[this.numInputGates];
        for (int i = 0; i < this.numInputGates; ++i) {
            this.inputGates[i] = new StreamTestSingleInputGate<IN>(this.numInputChannelsPerGate, this.bufferSize, this.inputSerializer);
            this.mockEnv.addInputGate((InputGate)this.inputGates[i].getInputGate());
        }
        this.streamConfig.setNumberOfInputs(1);
        this.streamConfig.setTypeSerializerIn1(this.inputSerializer);
    }

    public <K> void configureForKeyedStream(KeySelector<IN, K> keySelector, TypeInformation<K> keyType) {
        ClosureCleaner.clean(keySelector, (boolean)false);
        this.streamConfig.setStatePartitioner(0, keySelector);
        this.streamConfig.setStateKeySerializer(keyType.createSerializer(this.executionConfig));
    }
}

