/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.api.common.functions.StoppableFunction;
import org.apache.flink.streaming.api.functions.source.RichSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.StoppableStreamSource;
import org.apache.flink.streaming.runtime.tasks.StoppableSourceStreamTask;
import org.junit.Assert;
import org.junit.Test;

public class SourceStreamTaskStoppingTest {
    static boolean stopped = false;

    @Test
    public void testStop() {
        StoppableSourceStreamTask sourceTask = new StoppableSourceStreamTask();
        sourceTask.headOperator = new StoppableStreamSource((SourceFunction)new StoppableSource());
        sourceTask.stop();
        Assert.assertTrue((boolean)stopped);
    }

    @Test
    public void testStopBeforeInitialization() throws Exception {
        StoppableSourceStreamTask sourceTask = new StoppableSourceStreamTask();
        sourceTask.stop();
        sourceTask.headOperator = new StoppableStreamSource((SourceFunction)new StoppableFailingSource());
        sourceTask.run();
    }

    private static class StoppableFailingSource
    extends RichSourceFunction<Object>
    implements StoppableFunction {
        private static final long serialVersionUID = 728864804042338806L;

        private StoppableFailingSource() {
        }

        public void run(SourceFunction.SourceContext<Object> ctx) throws Exception {
            Assert.fail((String)"should not be called");
        }

        public void cancel() {
        }

        public void stop() {
        }
    }

    private static class StoppableSource
    extends RichSourceFunction<Object>
    implements StoppableFunction {
        private static final long serialVersionUID = 728864804042338806L;

        private StoppableSource() {
        }

        public void run(SourceFunction.SourceContext<Object> ctx) throws Exception {
        }

        public void cancel() {
        }

        public void stop() {
            stopped = true;
        }
    }
}

