/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.runtime.partitioner.BroadcastPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.util.Preconditions;

public class StreamConfigChainer {
    private final StreamConfig headConfig;
    private final Map<Integer, StreamConfig> chainedConfigs = new HashMap<Integer, StreamConfig>();
    private StreamConfig tailConfig;
    private int chainIndex = 0;

    public StreamConfigChainer(OperatorID headOperatorID, StreamOperator<?> headOperator, StreamConfig headConfig) {
        this.headConfig = (StreamConfig)Preconditions.checkNotNull((Object)headConfig);
        this.tailConfig = (StreamConfig)Preconditions.checkNotNull((Object)headConfig);
        this.head(headOperator, headOperatorID);
    }

    private void head(StreamOperator<?> headOperator, OperatorID headOperatorID) {
        this.headConfig.setStreamOperator(headOperator);
        this.headConfig.setOperatorID(headOperatorID);
        this.headConfig.setChainStart();
        this.headConfig.setChainIndex(this.chainIndex);
    }

    public <T> StreamConfigChainer chain(OperatorID operatorID, OneInputStreamOperator<T, T> operator, TypeSerializer<T> typeSerializer) {
        return this.chain(operatorID, operator, typeSerializer, typeSerializer);
    }

    public <IN, OUT> StreamConfigChainer chain(OperatorID operatorID, OneInputStreamOperator<IN, OUT> operator, TypeSerializer<IN> inputSerializer, TypeSerializer<OUT> outputSerializer) {
        ++this.chainIndex;
        this.tailConfig.setChainedOutputs(Collections.singletonList(new StreamEdge(new StreamNode(null, Integer.valueOf(this.tailConfig.getChainIndex()), null, null, null, null, null), new StreamNode(null, Integer.valueOf(this.chainIndex), null, null, null, null, null), 0, Collections.emptyList(), null, null)));
        this.tailConfig = new StreamConfig(new Configuration());
        this.tailConfig.setStreamOperator((StreamOperator)Preconditions.checkNotNull(operator));
        this.tailConfig.setOperatorID((OperatorID)Preconditions.checkNotNull((Object)operatorID));
        this.tailConfig.setTypeSerializerIn1(inputSerializer);
        this.tailConfig.setTypeSerializerOut(outputSerializer);
        this.tailConfig.setChainIndex(this.chainIndex);
        this.chainedConfigs.put(this.chainIndex, this.tailConfig);
        return this;
    }

    public void finish() {
        LinkedList<StreamEdge> outEdgesInOrder = new LinkedList<StreamEdge>();
        outEdgesInOrder.add(new StreamEdge(new StreamNode(null, Integer.valueOf(this.chainIndex), null, null, null, null, null), new StreamNode(null, Integer.valueOf(this.chainIndex), null, null, null, null, null), 0, Collections.emptyList(), (StreamPartitioner)new BroadcastPartitioner(), null));
        this.tailConfig.setBufferTimeout(0L);
        this.tailConfig.setChainEnd();
        this.tailConfig.setOutputSelectors(Collections.emptyList());
        this.tailConfig.setNumberOfOutputs(1);
        this.tailConfig.setOutEdgesInOrder(outEdgesInOrder);
        this.tailConfig.setNonChainedOutputs(outEdgesInOrder);
        this.headConfig.setTransitiveChainedTaskConfigs(this.chainedConfigs);
        this.headConfig.setOutEdgesInOrder(outEdgesInOrder);
    }
}

