/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Future;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.api.serialization.AdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.operators.testutils.MockInputSplitProvider;
import org.apache.flink.runtime.operators.testutils.UnregisteredTaskMetricsGroup;
import org.apache.flink.runtime.plugable.DeserializationDelegate;
import org.apache.flink.runtime.plugable.NonReusingDeserializationDelegate;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.runtime.util.TestingTaskManagerRuntimeInfo;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class StreamMockEnvironment
implements Environment {
    private final TaskInfo taskInfo;
    private final MemoryManager memManager;
    private final IOManager ioManager;
    private final InputSplitProvider inputSplitProvider;
    private final Configuration jobConfiguration;
    private final Configuration taskConfiguration;
    private final List<InputGate> inputs;
    private final List<ResultPartitionWriter> outputs;
    private final JobID jobID = new JobID();
    private final BroadcastVariableManager bcVarManager = new BroadcastVariableManager();
    private final AccumulatorRegistry accumulatorRegistry;
    private final TaskKvStateRegistry kvStateRegistry;
    private final int bufferSize;
    private final ExecutionConfig executionConfig;
    private volatile boolean wasFailedExternally = false;

    public StreamMockEnvironment(Configuration jobConfig, Configuration taskConfig, ExecutionConfig executionConfig, long memorySize, MockInputSplitProvider inputSplitProvider, int bufferSize) {
        this.taskInfo = new TaskInfo("", 1, 0, 1, 0);
        this.jobConfiguration = jobConfig;
        this.taskConfiguration = taskConfig;
        this.inputs = new LinkedList<InputGate>();
        this.outputs = new LinkedList<ResultPartitionWriter>();
        this.memManager = new MemoryManager(memorySize, 1);
        this.ioManager = new IOManagerAsync();
        this.inputSplitProvider = inputSplitProvider;
        this.bufferSize = bufferSize;
        this.executionConfig = executionConfig;
        this.accumulatorRegistry = new AccumulatorRegistry(this.jobID, this.getExecutionId());
        KvStateRegistry registry = new KvStateRegistry();
        this.kvStateRegistry = registry.createTaskRegistry(this.jobID, this.getJobVertexId());
    }

    public StreamMockEnvironment(Configuration jobConfig, Configuration taskConfig, long memorySize, MockInputSplitProvider inputSplitProvider, int bufferSize) {
        this(jobConfig, taskConfig, new ExecutionConfig(), memorySize, inputSplitProvider, bufferSize);
    }

    public void addInputGate(InputGate gate) {
        this.inputs.add(gate);
    }

    public <T> void addOutput(Queue<Object> outputList, TypeSerializer<T> serializer) {
        try {
            BufferProvider mockBufferProvider = (BufferProvider)Mockito.mock(BufferProvider.class);
            Mockito.when((Object)mockBufferProvider.requestBufferBlocking()).thenAnswer((Answer)new Answer<Buffer>(){

                public Buffer answer(InvocationOnMock invocationOnMock) throws Throwable {
                    return new Buffer(MemorySegmentFactory.allocateUnpooledSegment((int)StreamMockEnvironment.this.bufferSize), (BufferRecycler)Mockito.mock(BufferRecycler.class));
                }
            });
            ResultPartitionWriter mockWriter = (ResultPartitionWriter)Mockito.mock(ResultPartitionWriter.class);
            Mockito.when((Object)mockWriter.getNumberOfOutputChannels()).thenReturn((Object)1);
            Mockito.when((Object)mockWriter.getBufferProvider()).thenReturn((Object)mockBufferProvider);
            AdaptiveSpanningRecordDeserializer recordDeserializer = new AdaptiveSpanningRecordDeserializer();
            NonReusingDeserializationDelegate delegate = new NonReusingDeserializationDelegate(serializer);
            ((ResultPartitionWriter)Mockito.doAnswer((Answer)new Answer<Void>((RecordDeserializer)recordDeserializer, delegate, outputList){
                final /* synthetic */ RecordDeserializer val$recordDeserializer;
                final /* synthetic */ NonReusingDeserializationDelegate val$delegate;
                final /* synthetic */ Queue val$outputList;
                {
                    this.val$recordDeserializer = recordDeserializer;
                    this.val$delegate = nonReusingDeserializationDelegate;
                    this.val$outputList = queue;
                }

                public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                    Buffer buffer = (Buffer)invocationOnMock.getArguments()[0];
                    StreamMockEnvironment.this.addBufferToOutputList(this.val$recordDeserializer, this.val$delegate, buffer, this.val$outputList);
                    return null;
                }
            }).when((Object)mockWriter)).writeBuffer((Buffer)Matchers.any(Buffer.class), Matchers.anyInt());
            ((ResultPartitionWriter)Mockito.doAnswer((Answer)new Answer<Void>((RecordDeserializer)recordDeserializer, delegate, outputList){
                final /* synthetic */ RecordDeserializer val$recordDeserializer;
                final /* synthetic */ NonReusingDeserializationDelegate val$delegate;
                final /* synthetic */ Queue val$outputList;
                {
                    this.val$recordDeserializer = recordDeserializer;
                    this.val$delegate = nonReusingDeserializationDelegate;
                    this.val$outputList = queue;
                }

                public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                    Buffer buffer = (Buffer)invocationOnMock.getArguments()[0];
                    StreamMockEnvironment.this.addBufferToOutputList(this.val$recordDeserializer, this.val$delegate, buffer, this.val$outputList);
                    return null;
                }
            }).when((Object)mockWriter)).writeBufferToAllChannels((Buffer)Matchers.any(Buffer.class));
            this.outputs.add(mockWriter);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    private <T> void addBufferToOutputList(RecordDeserializer<DeserializationDelegate<T>> recordDeserializer, NonReusingDeserializationDelegate<T> delegate, Buffer buffer, Queue<Object> outputList) throws IOException {
        if (buffer.isBuffer()) {
            recordDeserializer.setNextBuffer(buffer);
            while (recordDeserializer.hasUnfinishedData()) {
                RecordDeserializer.DeserializationResult result = recordDeserializer.getNextRecord(delegate);
                if (result.isFullRecord()) {
                    outputList.add(delegate.getInstance());
                }
                if (result != RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER && result != RecordDeserializer.DeserializationResult.PARTIAL_RECORD) continue;
                break;
            }
        } else {
            AbstractEvent event = EventSerializer.fromBuffer((Buffer)buffer, (ClassLoader)this.getClass().getClassLoader());
            outputList.add(event);
        }
    }

    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    public MemoryManager getMemoryManager() {
        return this.memManager;
    }

    public IOManager getIOManager() {
        return this.ioManager;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public InputSplitProvider getInputSplitProvider() {
        return this.inputSplitProvider;
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public ClassLoader getUserClassLoader() {
        return this.getClass().getClassLoader();
    }

    public Map<String, Future<Path>> getDistributedCacheEntries() {
        return Collections.emptyMap();
    }

    public ResultPartitionWriter getWriter(int index) {
        return this.outputs.get(index);
    }

    public ResultPartitionWriter[] getAllWriters() {
        return this.outputs.toArray(new ResultPartitionWriter[this.outputs.size()]);
    }

    public InputGate getInputGate(int index) {
        return this.inputs.get(index);
    }

    public InputGate[] getAllInputGates() {
        InputGate[] gates = new InputGate[this.inputs.size()];
        this.inputs.toArray(gates);
        return gates;
    }

    public JobVertexID getJobVertexId() {
        return new JobVertexID(new byte[16]);
    }

    public ExecutionAttemptID getExecutionId() {
        return new ExecutionAttemptID(0L, 0L);
    }

    public BroadcastVariableManager getBroadcastVariableManager() {
        return this.bcVarManager;
    }

    public AccumulatorRegistry getAccumulatorRegistry() {
        return this.accumulatorRegistry;
    }

    public TaskKvStateRegistry getTaskKvStateRegistry() {
        return this.kvStateRegistry;
    }

    public void acknowledgeCheckpoint(long checkpointId, CheckpointMetrics checkpointMetrics) {
    }

    public void acknowledgeCheckpoint(long checkpointId, CheckpointMetrics checkpointMetrics, TaskStateSnapshot subtaskState) {
    }

    public void declineCheckpoint(long checkpointId, Throwable cause) {
    }

    public void failExternally(Throwable cause) {
        this.wasFailedExternally = true;
    }

    public boolean wasFailedExternally() {
        return this.wasFailedExternally;
    }

    public TaskManagerRuntimeInfo getTaskManagerInfo() {
        return new TestingTaskManagerRuntimeInfo();
    }

    public TaskMetricGroup getMetricGroup() {
        return new UnregisteredTaskMetricsGroup();
    }
}

