/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV1Serializer;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.streaming.runtime.tasks.OperatorStateHandles;

public class OperatorSnapshotUtil {
    public static String getResourceFilename(String filename) {
        ClassLoader cl = OperatorSnapshotUtil.class.getClassLoader();
        URL resource = cl.getResource(filename);
        return resource.getFile();
    }

    public static void writeStateHandle(OperatorStateHandles state, String path) throws IOException {
        FileOutputStream out = new FileOutputStream(path);
        try (DataOutputStream dos = new DataOutputStream(out);){
            dos.writeInt(state.getOperatorChainIndex());
            SavepointV1Serializer.serializeStreamStateHandle(null, (DataOutputStream)dos);
            Collection rawOperatorState = state.getRawOperatorState();
            if (rawOperatorState != null) {
                dos.writeInt(rawOperatorState.size());
                for (Object operatorStateHandle : rawOperatorState) {
                    SavepointV1Serializer.serializeOperatorStateHandle((OperatorStateHandle)operatorStateHandle, (DataOutputStream)dos);
                }
            } else {
                dos.writeInt(-1);
            }
            Collection managedOperatorState = state.getManagedOperatorState();
            if (managedOperatorState != null) {
                dos.writeInt(managedOperatorState.size());
                for (Object operatorStateHandle : managedOperatorState) {
                    SavepointV1Serializer.serializeOperatorStateHandle((OperatorStateHandle)operatorStateHandle, (DataOutputStream)dos);
                }
            } else {
                dos.writeInt(-1);
            }
            Collection rawKeyedState = state.getRawKeyedState();
            if (rawKeyedState != null) {
                dos.writeInt(rawKeyedState.size());
                for (KeyedStateHandle keyedStateHandle : rawKeyedState) {
                    SavepointV1Serializer.serializeKeyedStateHandle((KeyedStateHandle)keyedStateHandle, (DataOutputStream)dos);
                }
            } else {
                dos.writeInt(-1);
            }
            Collection managedKeyedState = state.getManagedKeyedState();
            if (managedKeyedState != null) {
                dos.writeInt(managedKeyedState.size());
                for (KeyedStateHandle keyedStateHandle : managedKeyedState) {
                    SavepointV1Serializer.serializeKeyedStateHandle((KeyedStateHandle)keyedStateHandle, (DataOutputStream)dos);
                }
            } else {
                dos.writeInt(-1);
            }
            dos.flush();
        }
    }

    public static OperatorStateHandles readStateHandle(String path) throws IOException, ClassNotFoundException {
        FileInputStream in = new FileInputStream(path);
        try (DataInputStream dis = new DataInputStream(in);){
            int index = dis.readInt();
            SavepointV1Serializer.deserializeStreamStateHandle((DataInputStream)dis);
            ArrayList<OperatorStateHandle> rawOperatorState = null;
            int numRawOperatorStates = dis.readInt();
            if (numRawOperatorStates >= 0) {
                rawOperatorState = new ArrayList<OperatorStateHandle>();
                for (int i = 0; i < numRawOperatorStates; ++i) {
                    OperatorStateHandle operatorState = SavepointV1Serializer.deserializeOperatorStateHandle((DataInputStream)dis);
                    rawOperatorState.add(operatorState);
                }
            }
            ArrayList<OperatorStateHandle> managedOperatorState = null;
            int numManagedOperatorStates = dis.readInt();
            if (numManagedOperatorStates >= 0) {
                managedOperatorState = new ArrayList<OperatorStateHandle>();
                for (int i = 0; i < numManagedOperatorStates; ++i) {
                    OperatorStateHandle operatorState = SavepointV1Serializer.deserializeOperatorStateHandle((DataInputStream)dis);
                    managedOperatorState.add(operatorState);
                }
            }
            ArrayList<KeyedStateHandle> rawKeyedState = null;
            int numRawKeyedStates = dis.readInt();
            if (numRawKeyedStates >= 0) {
                rawKeyedState = new ArrayList<KeyedStateHandle>();
                for (int i = 0; i < numRawKeyedStates; ++i) {
                    KeyedStateHandle keyedState = SavepointV1Serializer.deserializeKeyedStateHandle((DataInputStream)dis);
                    rawKeyedState.add(keyedState);
                }
            }
            ArrayList<KeyedStateHandle> managedKeyedState = null;
            int numManagedKeyedStates = dis.readInt();
            if (numManagedKeyedStates >= 0) {
                managedKeyedState = new ArrayList<KeyedStateHandle>();
                for (int i = 0; i < numManagedKeyedStates; ++i) {
                    KeyedStateHandle keyedState = SavepointV1Serializer.deserializeKeyedStateHandle((DataInputStream)dis);
                    managedKeyedState.add(keyedState);
                }
            }
            OperatorStateHandles operatorStateHandles = new OperatorStateHandles(index, managedKeyedState, rawKeyedState, managedOperatorState, rawOperatorState);
            return operatorStateHandles;
        }
    }
}

