/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.flink.shaded.guava18.com.google.common.collect.Iterables;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.junit.Assert;

public class TestHarnessUtil {
    public static <OUT> List<OUT> getRawElementsFromOutput(Queue<Object> output) {
        LinkedList<Object> resultElements = new LinkedList<Object>();
        for (Object e : output) {
            if (!(e instanceof StreamRecord)) continue;
            resultElements.add(((StreamRecord)e).getValue());
        }
        return resultElements;
    }

    public static <T> void assertOutputEquals(String message, Queue<T> expected, Queue<T> actual) {
        Assert.assertArrayEquals((String)message, (Object[])expected.toArray(), (Object[])actual.toArray());
    }

    public static void assertOutputEqualsSorted(String message, Iterable<Object> expected, Iterable<Object> actual, Comparator<Object> comparator) {
        Assert.assertEquals((long)Iterables.size(expected), (long)Iterables.size(actual));
        Iterator<Object> exIt = expected.iterator();
        Iterator<Object> actIt = actual.iterator();
        while (exIt.hasNext()) {
            Object nextEx = exIt.next();
            Object nextAct = actIt.next();
            if (!(nextEx instanceof Watermark)) continue;
            Assert.assertEquals((Object)nextEx, (Object)nextAct);
        }
        ArrayList<Object> expectedRecords = new ArrayList<Object>();
        ArrayList<Object> actualRecords = new ArrayList<Object>();
        for (Object ex : expected) {
            if (!(ex instanceof StreamRecord)) continue;
            expectedRecords.add(ex);
        }
        for (Object act : actual) {
            if (!(act instanceof StreamRecord)) continue;
            actualRecords.add(act);
        }
        Object[] sortedExpected = expectedRecords.toArray();
        Object[] sortedActual = actualRecords.toArray();
        Arrays.sort(sortedExpected, comparator);
        Arrays.sort(sortedActual, comparator);
        Assert.assertArrayEquals((String)message, (Object[])sortedExpected, (Object[])sortedActual);
    }
}

