/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.SimpleVersionedStringSerializer;

@PublicEvolving
public class DateTimeBucketAssigner<IN>
implements BucketAssigner<IN, String> {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_FORMAT_STRING = "yyyy-MM-dd--HH";
    private final String formatString;
    private transient SimpleDateFormat dateFormatter;

    public DateTimeBucketAssigner() {
        this(DEFAULT_FORMAT_STRING);
    }

    public DateTimeBucketAssigner(String formatString) {
        this.formatString = formatString;
    }

    @Override
    public String getBucketId(IN element, BucketAssigner.Context context) {
        if (this.dateFormatter == null) {
            this.dateFormatter = new SimpleDateFormat(this.formatString);
        }
        return this.dateFormatter.format(new Date(context.currentProcessingTime()));
    }

    @Override
    public SimpleVersionedSerializer<String> getSerializer() {
        return SimpleVersionedStringSerializer.INSTANCE;
    }

    public String toString() {
        return "DateTimeBucketAssigner{formatString='" + this.formatString + '\'' + '}';
    }
}

