/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class TestGetFileBlockLocations
extends TestCase {
    private static String TEST_ROOT_DIR = System.getProperty("test.build.data", "/tmp/testGetFileBlockLocations");
    private static final int FileLength = 0x400000;
    private Configuration conf;
    private Path path;
    private FileSystem fs;
    private Random random;

    protected void setUp() throws IOException {
        this.conf = new Configuration();
        Path rootPath = new Path(TEST_ROOT_DIR);
        this.path = new Path(rootPath, "TestGetFileBlockLocations");
        this.fs = rootPath.getFileSystem(this.conf);
        FSDataOutputStream fsdos = this.fs.create(this.path, true);
        byte[] buffer = new byte[1024];
        while (fsdos.getPos() < 0x400000L) {
            fsdos.write(buffer);
        }
        fsdos.close();
        this.random = new Random(System.nanoTime());
    }

    private void oneTest(int offBegin, int offEnd, FileStatus status) throws IOException {
        if (offBegin > offEnd) {
            int tmp = offBegin;
            offBegin = offEnd;
            offEnd = tmp;
        }
        BlockLocation[] locations = this.fs.getFileBlockLocations(status, (long)offBegin, (long)(offEnd - offBegin));
        if ((long)offBegin < status.getLen()) {
            Arrays.sort(locations, new Comparator<BlockLocation>(){

                @Override
                public int compare(BlockLocation arg0, BlockLocation arg1) {
                    long cmprv = arg0.getOffset() - arg1.getOffset();
                    if (cmprv < 0L) {
                        return -1;
                    }
                    if (cmprv > 0L) {
                        return 1;
                    }
                    cmprv = arg0.getLength() - arg1.getLength();
                    if (cmprv < 0L) {
                        return -1;
                    }
                    if (cmprv > 0L) {
                        return 1;
                    }
                    return 0;
                }
            });
            offBegin = (int)Math.min((long)offBegin, status.getLen() - 1L);
            offEnd = (int)Math.min((long)offEnd, status.getLen());
            BlockLocation first = locations[0];
            BlockLocation last = locations[locations.length - 1];
            TestGetFileBlockLocations.assertTrue((first.getOffset() <= (long)offBegin ? 1 : 0) != 0);
            TestGetFileBlockLocations.assertTrue(((long)offEnd <= last.getOffset() + last.getLength() ? 1 : 0) != 0);
        } else {
            TestGetFileBlockLocations.assertTrue((locations.length == 0 ? 1 : 0) != 0);
        }
    }

    protected void tearDown() throws IOException {
        this.fs.delete(this.path, true);
        this.fs.close();
    }

    public void testFailureNegativeParameters() throws IOException {
        BlockLocation[] locations2;
        FileStatus status = this.fs.getFileStatus(this.path);
        try {
            locations2 = this.fs.getFileBlockLocations(status, -1L, 100L);
            TestGetFileBlockLocations.fail((String)"Expecting exception being throw");
        }
        catch (IllegalArgumentException locations2) {
            // empty catch block
        }
        try {
            locations2 = this.fs.getFileBlockLocations(status, 100L, -1L);
            TestGetFileBlockLocations.fail((String)"Expecting exception being throw");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetFileBlockLocations1() throws IOException {
        FileStatus status = this.fs.getFileStatus(this.path);
        this.oneTest(0, (int)status.getLen(), status);
        this.oneTest(0, (int)status.getLen() * 2, status);
        this.oneTest((int)status.getLen() * 2, (int)status.getLen() * 4, status);
        this.oneTest((int)status.getLen() / 2, (int)status.getLen() * 3, status);
        this.oneTest((int)status.getLen(), (int)status.getLen() * 2, status);
        for (int i = 0; i < 10; ++i) {
            this.oneTest((int)status.getLen() * i / 10, (int)status.getLen() * (i + 1) / 10, status);
        }
    }

    public void testGetFileBlockLocations2() throws IOException {
        FileStatus status = this.fs.getFileStatus(this.path);
        for (int i = 0; i < 1000; ++i) {
            int offBegin = this.random.nextInt((int)(2L * status.getLen()));
            int offEnd = this.random.nextInt((int)(2L * status.getLen()));
            this.oneTest(offBegin, offEnd, status);
        }
    }
}

