/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContract;

public abstract class AbstractBondedFSContract
extends AbstractFSContract {
    private static final Log LOG = LogFactory.getLog(AbstractBondedFSContract.class);
    public static final String FSNAME_OPTION = "test.fs.%s";
    private String fsName;
    private URI fsURI;
    private FileSystem filesystem;

    protected AbstractBondedFSContract(Configuration conf) {
        super(conf);
    }

    @Override
    public void init() throws IOException {
        super.init();
        this.fsName = this.loadFilesystemName(this.getScheme());
        this.setEnabled(!this.fsName.isEmpty());
        if (this.isEnabled()) {
            try {
                this.fsURI = new URI(this.fsName);
                this.filesystem = FileSystem.get((URI)this.fsURI, (Configuration)this.getConf());
            }
            catch (URISyntaxException e) {
                throw new IOException("Invalid URI " + this.fsName);
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Invalid URI " + this.fsName, e);
            }
        } else {
            LOG.info((Object)("skipping tests as FS name is not defined in " + this.getFilesystemConfKey()));
        }
    }

    public String loadFilesystemName(String schema) {
        return this.getOption(String.format(FSNAME_OPTION, schema), "");
    }

    protected String getFilesystemConfKey() {
        return this.getConfKey(String.format(FSNAME_OPTION, this.getScheme()));
    }

    @Override
    public FileSystem getTestFileSystem() throws IOException {
        return this.filesystem;
    }

    @Override
    public Path getTestPath() {
        Path path = new Path("/test");
        return path;
    }

    @Override
    public String toString() {
        return this.getScheme() + " Contract against " + this.fsName;
    }
}

