/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.net.StaticMapping;
import org.apache.hadoop.security.AccessControlException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultBlockPlacementPolicy {
    private Configuration conf;
    private final short REPLICATION_FACTOR = (short)3;
    private final int DEFAULT_BLOCK_SIZE = 1024;
    private MiniDFSCluster cluster = null;
    private NamenodeProtocols nameNodeRpc = null;
    private FSNamesystem namesystem = null;
    private PermissionStatus perm = null;

    @Before
    public void setup() throws IOException {
        StaticMapping.resetMap();
        this.conf = new HdfsConfiguration();
        String[] racks = new String[]{"/RACK0", "/RACK0", "/RACK2", "/RACK3", "/RACK2"};
        String[] hosts = new String[]{"/host0", "/host1", "/host2", "/host3", "/host4"};
        this.conf.setLong("dfs.blocksize", 1024L);
        this.conf.setInt("dfs.bytes-per-checksum", 512);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(5).racks(racks).hosts(hosts).build();
        this.cluster.waitActive();
        this.nameNodeRpc = this.cluster.getNameNodeRpc();
        this.namesystem = this.cluster.getNamesystem();
        this.perm = new PermissionStatus("TestDefaultBlockPlacementPolicy", null, FsPermission.getDefault());
    }

    @After
    public void teardown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testLocalRackPlacement() throws Exception {
        String clientMachine = "client.foo.com";
        String clientRack = "/RACK2";
        StaticMapping.addNodeToRack((String)clientMachine, (String)clientRack);
        this.testPlacement(clientMachine, clientRack);
    }

    @Test
    public void testRandomRackSelectionForRemoteClient() throws Exception {
        String clientMachine = "client.foo.com";
        this.testPlacement(clientMachine, null);
    }

    private void testPlacement(String clientMachine, String clientRack) throws AccessControlException, SafeModeException, FileAlreadyExistsException, UnresolvedLinkException, FileNotFoundException, ParentNotDirectoryException, IOException, NotReplicatedYetException {
        for (int i = 0; i < 5; ++i) {
            String src = "/test-" + i;
            HdfsFileStatus fileStatus = this.namesystem.startFile(src, this.perm, clientMachine, clientMachine, EnumSet.of(CreateFlag.CREATE), true, (short)3, 1024L, null);
            LocatedBlock locatedBlock = this.nameNodeRpc.addBlock(src, clientMachine, null, null, fileStatus.getFileId(), null);
            Assert.assertEquals((String)"Block should be allocated sufficient locations", (long)3L, (long)locatedBlock.getLocations().length);
            if (clientRack != null) {
                Assert.assertEquals((String)"First datanode should be rack local", (Object)clientRack, (Object)locatedBlock.getLocations()[0].getNetworkLocation());
            }
            this.nameNodeRpc.abandonBlock(locatedBlock.getBlock(), fileStatus.getFileId(), src, clientMachine);
        }
    }
}

