/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tracing;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tracing.SpanReceiverHost;
import org.htrace.HTraceConfiguration;
import org.htrace.Sampler;
import org.htrace.Span;
import org.htrace.SpanReceiver;
import org.htrace.Trace;
import org.htrace.TraceScope;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTracing {
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem dfs;
    private static SpanReceiverHost spanReceiverHost;

    @Test
    public void testGetSpanReceiverHost() throws Exception {
        Configuration c = new Configuration();
        c.set("hadoop.trace.spanreceiver.classes", "");
        SpanReceiverHost s = SpanReceiverHost.getInstance((Configuration)c);
        Assert.assertEquals((Object)spanReceiverHost, (Object)s);
    }

    @Test
    public void testWriteTraceHooks() throws Exception {
        long startTime = System.currentTimeMillis();
        TraceScope ts = Trace.startSpan((String)"testWriteTraceHooks", (Sampler)Sampler.ALWAYS);
        Path file = new Path("traceWriteTest.dat");
        FSDataOutputStream stream = dfs.create(file);
        for (int i = 0; i < 10; ++i) {
            byte[] data = RandomStringUtils.randomAlphabetic((int)102400).getBytes();
            stream.write(data);
        }
        stream.hflush();
        stream.close();
        long endTime = System.currentTimeMillis();
        ts.close();
        String[] expectedSpanNames = new String[]{"testWriteTraceHooks", "org.apache.hadoop.hdfs.protocol.ClientProtocol.create", "org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos.ClientNamenodeProtocol.BlockingInterface.create", "org.apache.hadoop.hdfs.protocol.ClientProtocol.fsync", "org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos.ClientNamenodeProtocol.BlockingInterface.fsync", "org.apache.hadoop.hdfs.protocol.ClientProtocol.complete", "org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos.ClientNamenodeProtocol.BlockingInterface.complete", "DFSOutputStream", "OpWriteBlockProto", "org.apache.hadoop.hdfs.protocol.ClientProtocol.addBlock", "org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos.ClientNamenodeProtocol.BlockingInterface.addBlock"};
        TestTracing.assertSpanNamesFound(expectedSpanNames);
        Map<String, List<Span>> map = SetSpanReceiver.SetHolder.getMap();
        Span s = map.get("testWriteTraceHooks").get(0);
        Assert.assertNotNull((Object)s);
        long spanStart = s.getStartTimeMillis();
        long spanEnd = s.getStopTimeMillis();
        Assert.assertTrue((spanStart - startTime < 100L ? 1 : 0) != 0);
        Assert.assertTrue((spanEnd - endTime < 100L ? 1 : 0) != 0);
        for (Span span : SetSpanReceiver.SetHolder.spans.values()) {
            Assert.assertEquals((long)ts.getSpan().getTraceId(), (long)span.getTraceId());
        }
    }

    @Test
    public void testWriteWithoutTraceHooks() throws Exception {
        Path file = new Path("withoutTraceWriteTest.dat");
        FSDataOutputStream stream = dfs.create(file);
        for (int i = 0; i < 10; ++i) {
            byte[] data = RandomStringUtils.randomAlphabetic((int)102400).getBytes();
            stream.write(data);
        }
        stream.hflush();
        stream.close();
        Assert.assertTrue((SetSpanReceiver.SetHolder.size() == 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadTraceHooks() throws Exception {
        String fileName = "traceReadTest.dat";
        Path filePath = new Path(fileName);
        FSDataOutputStream ostream = dfs.create(filePath);
        for (int i = 0; i < 50; ++i) {
            byte[] data = RandomStringUtils.randomAlphabetic((int)10240).getBytes();
            ostream.write(data);
        }
        ostream.close();
        long startTime = System.currentTimeMillis();
        TraceScope ts = Trace.startSpan((String)"testReadTraceHooks", (Sampler)Sampler.ALWAYS);
        FSDataInputStream istream = dfs.open(filePath, 10240);
        ByteBuffer buf = ByteBuffer.allocate(10240);
        int count = 0;
        try {
            while (istream.read(buf) > 0) {
                ++count;
                buf.clear();
                istream.seek(istream.getPos() + 5L);
            }
        }
        catch (IOException ioe) {
        }
        finally {
            istream.close();
        }
        ts.getSpan().addTimelineAnnotation("count: " + count);
        long endTime = System.currentTimeMillis();
        ts.close();
        String[] expectedSpanNames = new String[]{"testReadTraceHooks", "org.apache.hadoop.hdfs.protocol.ClientProtocol.getBlockLocations", "org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos.ClientNamenodeProtocol.BlockingInterface.getBlockLocations", "OpReadBlockProto"};
        TestTracing.assertSpanNamesFound(expectedSpanNames);
        Map<String, List<Span>> map = SetSpanReceiver.SetHolder.getMap();
        Span s = map.get("testReadTraceHooks").get(0);
        Assert.assertNotNull((Object)s);
        long spanStart = s.getStartTimeMillis();
        long spanEnd = s.getStopTimeMillis();
        Assert.assertTrue((spanStart - startTime < 100L ? 1 : 0) != 0);
        Assert.assertTrue((spanEnd - endTime < 100L ? 1 : 0) != 0);
        for (Span span : SetSpanReceiver.SetHolder.spans.values()) {
            Assert.assertEquals((long)ts.getSpan().getTraceId(), (long)span.getTraceId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWithoutTraceHooks() throws Exception {
        String fileName = "withoutTraceReadTest.dat";
        Path filePath = new Path(fileName);
        FSDataOutputStream ostream = dfs.create(filePath);
        for (int i = 0; i < 50; ++i) {
            byte[] data = RandomStringUtils.randomAlphabetic((int)10240).getBytes();
            ostream.write(data);
        }
        ostream.close();
        FSDataInputStream istream = dfs.open(filePath, 10240);
        ByteBuffer buf = ByteBuffer.allocate(10240);
        int count = 0;
        try {
            while (istream.read(buf) > 0) {
                ++count;
                buf.clear();
                istream.seek(istream.getPos() + 5L);
            }
        }
        catch (IOException ioe) {
        }
        finally {
            istream.close();
        }
        Assert.assertTrue((SetSpanReceiver.SetHolder.size() == 0 ? 1 : 0) != 0);
    }

    @Before
    public void cleanSet() {
        SetSpanReceiver.SetHolder.spans.clear();
    }

    @BeforeClass
    public static void setupCluster() throws IOException {
        conf = new Configuration();
        conf.setLong("dfs.blocksize", 102400L);
        conf.set("hadoop.trace.spanreceiver.classes", SetSpanReceiver.class.getName());
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        dfs = cluster.getFileSystem();
        spanReceiverHost = SpanReceiverHost.getInstance((Configuration)conf);
    }

    @AfterClass
    public static void shutDown() throws IOException {
        cluster.shutdown();
    }

    static void assertSpanNamesFound(final String[] expectedSpanNames) {
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    Map<String, List<Span>> map = SetSpanReceiver.SetHolder.getMap();
                    for (String spanName : expectedSpanNames) {
                        if (map.containsKey(spanName)) continue;
                        return false;
                    }
                    return true;
                }
            }, (int)100, (int)1000);
        }
        catch (TimeoutException e) {
            Assert.fail((String)("timed out to get expected spans: " + e.getMessage()));
        }
        catch (InterruptedException e) {
            Assert.fail((String)("interrupted while waiting spans: " + e.getMessage()));
        }
    }

    public static class SetSpanReceiver
    implements SpanReceiver {
        public void configure(HTraceConfiguration conf) {
        }

        public void receiveSpan(Span span) {
            SetHolder.spans.put(span.getSpanId(), span);
        }

        public void close() {
        }

        public static class SetHolder {
            public static ConcurrentHashMap<Long, Span> spans = new ConcurrentHashMap();

            public static int size() {
                return spans.size();
            }

            public static Map<String, List<Span>> getMap() {
                HashMap<String, List<Span>> map = new HashMap<String, List<Span>>();
                for (Span s : spans.values()) {
                    LinkedList<Span> l = (LinkedList<Span>)map.get(s.getDescription());
                    if (l == null) {
                        l = new LinkedList<Span>();
                        map.put(s.getDescription(), l);
                    }
                    l.add(s);
                }
                return map;
            }
        }
    }
}

