/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestWriteRead {
    private static final int WR_NTIMES = 350;
    private static final int WR_CHUNK_SIZE = 10000;
    private static final int BUFFER_SIZE = 819200;
    private static final String ROOT_DIR = "/tmp/";
    private static final long blockSize = 102400L;
    String filenameOption = "/tmp/fileX1";
    int chunkSizeOption = 10000;
    int loopOption = 10;
    private MiniDFSCluster cluster;
    private Configuration conf;
    private FileSystem mfs;
    private FileContext mfc;
    private boolean useFCOption = false;
    private boolean verboseOption = true;
    private boolean positionReadOption = false;
    private boolean truncateOption = false;
    private final boolean abortTestOnFailure = true;
    private static Log LOG = LogFactory.getLog(TestWriteRead.class);

    @Before
    public void initJunitModeTest() throws Exception {
        LOG.info((Object)"initJunitModeTest");
        this.conf = new HdfsConfiguration();
        this.conf.setLong("dfs.blocksize", 102400L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.mfs = this.cluster.getFileSystem();
        this.mfc = FileContext.getFileContext();
        Path rootdir = new Path(ROOT_DIR);
        this.mfs.mkdirs(rootdir);
    }

    @After
    public void shutdown() {
        this.cluster.shutdown();
    }

    private void initClusterModeTest() throws IOException {
        LOG = LogFactory.getLog(TestWriteRead.class);
        LOG.info((Object)"initClusterModeTest");
        this.conf = new Configuration();
        this.mfc = FileContext.getFileContext();
        this.mfs = FileSystem.get((Configuration)this.conf);
    }

    @Test
    public void testWriteReadSeq() throws IOException {
        this.useFCOption = false;
        this.positionReadOption = false;
        String fname = this.filenameOption;
        long rdBeginPos = 0L;
        int stat = this.testWriteAndRead(fname, 350, 10000, rdBeginPos);
        LOG.info((Object)("Summary status from test1: status= " + stat));
        Assert.assertEquals((long)0L, (long)stat);
    }

    @Test
    public void testWriteReadPos() throws IOException {
        String fname = this.filenameOption;
        this.positionReadOption = true;
        long rdBeginPos = 0L;
        int stat = this.testWriteAndRead(fname, 350, 10000, rdBeginPos);
        Assert.assertEquals((long)0L, (long)stat);
    }

    @Test
    public void testReadPosCurrentBlock() throws IOException {
        String fname = this.filenameOption;
        this.positionReadOption = true;
        int wrChunkSize = 153600;
        long rdBeginPos = 102401L;
        int numTimes = 5;
        int stat = this.testWriteAndRead(fname, numTimes, wrChunkSize, rdBeginPos);
        Assert.assertEquals((long)0L, (long)stat);
    }

    private int clusterTestWriteRead1() throws IOException {
        long rdBeginPos = 0L;
        int stat = this.testWriteAndRead(this.filenameOption, this.loopOption, this.chunkSizeOption, rdBeginPos);
        return stat;
    }

    private long readData(String fname, byte[] buffer, long byteExpected, long beginPosition) throws IOException {
        long totalByteRead = 0L;
        Path path = this.getFullyQualifiedPath(fname);
        FSDataInputStream in = null;
        try {
            in = this.openInputStream(path);
            long visibleLenFromReadStream = ((HdfsDataInputStream)in).getVisibleLength();
            if (visibleLenFromReadStream < byteExpected) {
                throw new IOException(visibleLenFromReadStream + " = visibleLenFromReadStream < bytesExpected= " + byteExpected);
            }
            totalByteRead = this.readUntilEnd(in, buffer, buffer.length, fname, beginPosition, visibleLenFromReadStream, this.positionReadOption);
            in.close();
            if (totalByteRead + beginPosition < byteExpected) {
                throw new IOException("readData mismatch in byte read: expected=" + byteExpected + " ; got " + (totalByteRead + beginPosition));
            }
            long l = totalByteRead + beginPosition;
            return l;
        }
        catch (IOException e) {
            throw new IOException("##### Caught Exception in readData. Total Byte Read so far = " + totalByteRead + " beginPosition = " + beginPosition, e);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private long readUntilEnd(FSDataInputStream in, byte[] buffer, long size, String fname, long pos, long visibleLen, boolean positionReadOption) throws IOException {
        if (pos >= visibleLen || visibleLen <= 0L) {
            return 0L;
        }
        int chunkNumber = 0;
        long totalByteRead = 0L;
        long currentPosition = pos;
        int byteRead = 0;
        long byteLeftToRead = visibleLen - pos;
        int byteToReadThisRound = 0;
        if (!positionReadOption) {
            in.seek(pos);
            currentPosition = in.getPos();
        }
        if (this.verboseOption) {
            LOG.info((Object)("reader begin: position: " + pos + " ; currentOffset = " + currentPosition + " ; bufferSize =" + buffer.length + " ; Filename = " + fname));
        }
        try {
            while (byteLeftToRead > 0L && currentPosition < visibleLen) {
                byteToReadThisRound = (int)(byteLeftToRead >= (long)buffer.length ? (long)buffer.length : byteLeftToRead);
                byteRead = positionReadOption ? in.read(currentPosition, buffer, 0, byteToReadThisRound) : in.read(buffer, 0, byteToReadThisRound);
                if (byteRead > 0) {
                    ++chunkNumber;
                    totalByteRead += (long)byteRead;
                    currentPosition += (long)byteRead;
                    byteLeftToRead -= (long)byteRead;
                    if (!this.verboseOption) continue;
                    LOG.info((Object)("reader: Number of byte read: " + byteRead + " ; totalByteRead = " + totalByteRead + " ; currentPosition=" + currentPosition + " ; chunkNumber =" + chunkNumber + "; File name = " + fname));
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new IOException("#### Exception caught in readUntilEnd: reader  currentOffset = " + currentPosition + " ; totalByteRead =" + totalByteRead + " ; latest byteRead = " + byteRead + "; visibleLen= " + visibleLen + " ; bufferLen = " + buffer.length + " ; Filename = " + fname, e);
        }
        if (this.verboseOption) {
            LOG.info((Object)("reader end:   position: " + pos + " ; currentOffset = " + currentPosition + " ; totalByteRead =" + totalByteRead + " ; Filename = " + fname));
        }
        return totalByteRead;
    }

    private void writeData(FSDataOutputStream out, byte[] buffer, int length) throws IOException {
        int toWriteThisRound;
        int totalByteWritten = 0;
        for (int remainToWrite = length; remainToWrite > 0; remainToWrite -= toWriteThisRound) {
            toWriteThisRound = remainToWrite > buffer.length ? buffer.length : remainToWrite;
            out.write(buffer, 0, toWriteThisRound);
            totalByteWritten += toWriteThisRound;
        }
        if (totalByteWritten != length) {
            throw new IOException("WriteData: failure in write. Attempt to write " + length + " ; written=" + totalByteWritten);
        }
    }

    private int testWriteAndRead(String fname, int loopN, int chunkSize, long readBeginPosition) throws IOException {
        int countOfFailures = 0;
        long byteVisibleToRead = 0L;
        FSDataOutputStream out = null;
        byte[] outBuffer = new byte[819200];
        byte[] inBuffer = new byte[819200];
        for (int i = 0; i < 819200; ++i) {
            outBuffer[i] = (byte)(i & 0xFF);
        }
        try {
            String readmsg;
            Path path = this.getFullyQualifiedPath(fname);
            long fileLengthBeforeOpen = 0L;
            if (this.ifExists(path)) {
                if (this.truncateOption) {
                    out = this.useFCOption ? this.mfc.create(path, EnumSet.of(CreateFlag.OVERWRITE), new Options.CreateOpts[0]) : this.mfs.create(path, this.truncateOption);
                    LOG.info((Object)("File already exists. File open with Truncate mode: " + path));
                } else {
                    out = this.useFCOption ? this.mfc.create(path, EnumSet.of(CreateFlag.APPEND), new Options.CreateOpts[0]) : this.mfs.append(path);
                    fileLengthBeforeOpen = this.getFileLengthFromNN(path);
                    LOG.info((Object)("File already exists of size " + fileLengthBeforeOpen + " File open for Append mode: " + path));
                }
            } else {
                out = this.useFCOption ? this.mfc.create(path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]) : this.mfs.create(path);
            }
            long totalByteWritten = fileLengthBeforeOpen;
            long totalByteVisible = fileLengthBeforeOpen;
            long totalByteWrittenButNotVisible = 0L;
            for (int i = 0; i < loopN; ++i) {
                boolean toFlush = i % 2 == 0;
                this.writeData(out, outBuffer, chunkSize);
                totalByteWritten += (long)chunkSize;
                if (toFlush) {
                    out.hflush();
                    totalByteVisible += (long)chunkSize + totalByteWrittenButNotVisible;
                    totalByteWrittenButNotVisible = 0L;
                } else {
                    totalByteWrittenButNotVisible += (long)chunkSize;
                }
                if (this.verboseOption) {
                    LOG.info((Object)("TestReadWrite - Written " + chunkSize + ". Total written = " + totalByteWritten + ". TotalByteVisible = " + totalByteVisible + " to file " + fname));
                }
                byteVisibleToRead = this.readData(fname, inBuffer, totalByteVisible, readBeginPosition);
                readmsg = "Written=" + totalByteWritten + " ; Expected Visible=" + totalByteVisible + " ; Got Visible=" + byteVisibleToRead + " of file " + fname;
                if (byteVisibleToRead < totalByteVisible || byteVisibleToRead > totalByteWritten) {
                    ++countOfFailures;
                    readmsg = "fail: reader see different number of visible byte. " + readmsg + " [fail]";
                    throw new IOException(readmsg);
                }
                readmsg = "pass: reader sees expected number of visible byte. " + readmsg + " [pass]";
                LOG.info((Object)readmsg);
            }
            this.writeData(out, outBuffer, chunkSize);
            totalByteVisible += (long)chunkSize + totalByteWrittenButNotVisible;
            totalByteWrittenButNotVisible += 0L;
            out.close();
            byteVisibleToRead = this.readData(fname, inBuffer, totalByteVisible, readBeginPosition);
            String readmsg2 = "Written=" + (totalByteWritten += (long)chunkSize) + " ; Expected Visible=" + totalByteVisible + " ; Got Visible=" + byteVisibleToRead + " of file " + fname;
            if (byteVisibleToRead < totalByteVisible || byteVisibleToRead > totalByteWritten) {
                ++countOfFailures;
                readmsg = "fail: reader sees different number of visible byte on close. " + readmsg2 + " [fail]";
                LOG.info((Object)readmsg);
                throw new IOException(readmsg);
            }
            readmsg = "pass: reader sees expected number of visible byte on close. " + readmsg2 + " [pass]";
            long lenFromFc = this.getFileLengthFromNN(path);
            if (lenFromFc != byteVisibleToRead) {
                readmsg = "fail: reader sees different number of visible byte from NN " + readmsg2 + " [fail]";
                throw new IOException(readmsg);
            }
        }
        catch (IOException e) {
            throw new IOException("##### Caught Exception in testAppendWriteAndRead. Close file. Total Byte Read so far = " + byteVisibleToRead, e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return -countOfFailures;
    }

    private FSDataInputStream openInputStream(Path path) throws IOException {
        FSDataInputStream in = this.useFCOption ? this.mfc.open(path) : this.mfs.open(path);
        return in;
    }

    private long getFileLengthFromNN(Path path) throws IOException {
        FileStatus fileStatus = this.useFCOption ? this.mfc.getFileStatus(path) : this.mfs.getFileStatus(path);
        return fileStatus.getLen();
    }

    private boolean ifExists(Path path) throws IOException {
        return this.useFCOption ? this.mfc.util().exists(path) : this.mfs.exists(path);
    }

    private Path getFullyQualifiedPath(String pathString) {
        return this.useFCOption ? this.mfc.makeQualified(new Path(ROOT_DIR, pathString)) : this.mfs.makeQualified(new Path(ROOT_DIR, pathString));
    }

    private void usage() {
        LOG.info((Object)"Usage: [-useSeqRead | -usePosRead] [-append|truncate] -chunkSize nn -loop ntimes  -f filename");
        System.out.println("Usage: [-useSeqRead | -usePosRead] [-append|truncate] -chunkSize nn -loop ntimes  -f filename");
        System.out.println("Defaults: -chunkSize=10000, -loop=10, -f=/tmp/fileX1, use sequential read, use append mode if file already exists");
        System.exit(0);
    }

    private void dumpOptions() {
        LOG.info((Object)("  Option setting: filenameOption = " + this.filenameOption));
        LOG.info((Object)("  Option setting: chunkSizeOption = " + this.chunkSizeOption));
        LOG.info((Object)("  Option setting: loopOption = " + this.loopOption));
        LOG.info((Object)("  Option setting: posReadOption = " + this.positionReadOption));
        LOG.info((Object)("  Option setting: truncateOption = " + this.truncateOption));
        LOG.info((Object)("  Option setting: verboseOption = " + this.verboseOption));
    }

    private void getCmdLineOption(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-f")) {
                this.filenameOption = args[++i];
                continue;
            }
            if (args[i].equals("-chunkSize")) {
                this.chunkSizeOption = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-loop")) {
                this.loopOption = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-usePosRead")) {
                this.positionReadOption = true;
                continue;
            }
            if (args[i].equals("-useSeqRead")) {
                this.positionReadOption = false;
                continue;
            }
            if (args[i].equals("-truncate")) {
                this.truncateOption = true;
                continue;
            }
            if (args[i].equals("-append")) {
                this.truncateOption = false;
                continue;
            }
            if (args[i].equals("-verbose")) {
                this.verboseOption = true;
                continue;
            }
            if (args[i].equals("-noVerbose")) {
                this.verboseOption = false;
                continue;
            }
            this.usage();
        }
        if (this.verboseOption) {
            this.dumpOptions();
        }
    }

    public static void main(String[] args) {
        try {
            TestWriteRead trw = new TestWriteRead();
            trw.initClusterModeTest();
            trw.getCmdLineOption(args);
            int stat = trw.clusterTestWriteRead1();
            if (stat == 0) {
                System.out.println("Status: clusterTestWriteRead1 test PASS");
            } else {
                System.out.println("Status: clusterTestWriteRead1 test FAIL with " + stat + " failures");
            }
            System.exit(stat);
        }
        catch (IOException e) {
            LOG.info((Object)"#### Exception in Main");
            e.printStackTrace();
            System.exit(-2);
        }
    }
}

