/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.ByteBufferUtil;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.hdfs.ClientContext;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.client.impl.BlockReaderTestUtil;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitCache;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitReplica;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestEnhancedByteBufferAccess {
    private static final Log LOG = LogFactory.getLog((String)TestEnhancedByteBufferAccess.class.getName());
    private static TemporarySocketDirectory sockDir;
    private static NativeIO.POSIX.CacheManipulator prevCacheManipulator;
    private static final int BLOCK_SIZE;

    @BeforeClass
    public static void init() {
        sockDir = new TemporarySocketDirectory();
        DomainSocket.disableBindPathValidation();
        prevCacheManipulator = NativeIO.POSIX.getCacheManipulator();
        NativeIO.POSIX.setCacheManipulator((NativeIO.POSIX.CacheManipulator)new NativeIO.POSIX.CacheManipulator(){

            public void mlock(String identifier, ByteBuffer mmap, long length) throws IOException {
                LOG.info((Object)("mlocking " + identifier));
            }
        });
    }

    @AfterClass
    public static void teardown() {
        NativeIO.POSIX.setCacheManipulator((NativeIO.POSIX.CacheManipulator)prevCacheManipulator);
    }

    private static byte[] byteBufferToArray(ByteBuffer buf) {
        byte[] resultArray = new byte[buf.remaining()];
        buf.get(resultArray);
        buf.flip();
        return resultArray;
    }

    public static HdfsConfiguration initZeroCopyTest() {
        Assume.assumeTrue((boolean)NativeIO.isAvailable());
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_UNIX);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
        conf.setLong("dfs.blocksize", (long)BLOCK_SIZE);
        conf.setInt("dfs.client.mmap.cache.size", 3);
        conf.setLong("dfs.client.mmap.cache.timeout.ms", 100L);
        conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), "TestRequestMmapAccess._PORT.sock").getAbsolutePath());
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", true);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setLong("dfs.cachereport.intervalMsec", 1000L);
        conf.setLong("dfs.namenode.path.based.cache.refresh.interval.ms", 1000L);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZeroCopyReads() throws Exception {
        HdfsConfiguration conf = TestEnhancedByteBufferAccess.initZeroCopyTest();
        MiniDFSCluster cluster = null;
        Path TEST_PATH = new Path("/a");
        FSDataInputStream fsIn = null;
        int TEST_FILE_LENGTH = 3 * BLOCK_SIZE;
        DistributedFileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, TEST_FILE_LENGTH, (short)1, 7567L);
            try {
                DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("unexpected InterruptedException during waitReplication: " + e));
            }
            catch (TimeoutException e) {
                Assert.fail((String)("unexpected TimeoutException during waitReplication: " + e));
            }
            fsIn = fs.open(TEST_PATH);
            byte[] original = new byte[TEST_FILE_LENGTH];
            IOUtils.readFully((InputStream)fsIn, (byte[])original, (int)0, (int)TEST_FILE_LENGTH);
            fsIn.close();
            fsIn = fs.open(TEST_PATH);
            ByteBuffer result = fsIn.read(null, BLOCK_SIZE, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
            Assert.assertEquals((long)BLOCK_SIZE, (long)result.remaining());
            HdfsDataInputStream dfsIn = (HdfsDataInputStream)fsIn;
            Assert.assertEquals((long)BLOCK_SIZE, (long)dfsIn.getReadStatistics().getTotalBytesRead());
            Assert.assertEquals((long)BLOCK_SIZE, (long)dfsIn.getReadStatistics().getTotalZeroCopyBytesRead());
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(original, 0, BLOCK_SIZE), (byte[])TestEnhancedByteBufferAccess.byteBufferToArray(result));
            fsIn.releaseBuffer(result);
        }
        finally {
            if (fsIn != null) {
                fsIn.close();
            }
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShortZeroCopyReads() throws Exception {
        HdfsConfiguration conf = TestEnhancedByteBufferAccess.initZeroCopyTest();
        MiniDFSCluster cluster = null;
        Path TEST_PATH = new Path("/a");
        FSDataInputStream fsIn = null;
        int TEST_FILE_LENGTH = 3 * BLOCK_SIZE;
        DistributedFileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, TEST_FILE_LENGTH, (short)1, 7567L);
            try {
                DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("unexpected InterruptedException during waitReplication: " + e));
            }
            catch (TimeoutException e) {
                Assert.fail((String)("unexpected TimeoutException during waitReplication: " + e));
            }
            fsIn = fs.open(TEST_PATH);
            byte[] original = new byte[TEST_FILE_LENGTH];
            IOUtils.readFully((InputStream)fsIn, (byte[])original, (int)0, (int)TEST_FILE_LENGTH);
            fsIn.close();
            fsIn = fs.open(TEST_PATH);
            HdfsDataInputStream dfsIn = (HdfsDataInputStream)fsIn;
            ByteBuffer result = dfsIn.read(null, 2 * BLOCK_SIZE, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
            Assert.assertEquals((long)BLOCK_SIZE, (long)result.remaining());
            Assert.assertEquals((long)BLOCK_SIZE, (long)dfsIn.getReadStatistics().getTotalBytesRead());
            Assert.assertEquals((long)BLOCK_SIZE, (long)dfsIn.getReadStatistics().getTotalZeroCopyBytesRead());
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(original, 0, BLOCK_SIZE), (byte[])TestEnhancedByteBufferAccess.byteBufferToArray(result));
            dfsIn.releaseBuffer(result);
            result = dfsIn.read(null, 1 + BLOCK_SIZE, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
            Assert.assertEquals((long)BLOCK_SIZE, (long)result.remaining());
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(original, BLOCK_SIZE, 2 * BLOCK_SIZE), (byte[])TestEnhancedByteBufferAccess.byteBufferToArray(result));
            dfsIn.releaseBuffer(result);
        }
        finally {
            if (fsIn != null) {
                fsIn.close();
            }
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZeroCopyReadsNoFallback() throws Exception {
        HdfsConfiguration conf = TestEnhancedByteBufferAccess.initZeroCopyTest();
        MiniDFSCluster cluster = null;
        Path TEST_PATH = new Path("/a");
        FSDataInputStream fsIn = null;
        int TEST_FILE_LENGTH = 3 * BLOCK_SIZE;
        DistributedFileSystem fs = null;
        try {
            ByteBuffer result;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, TEST_FILE_LENGTH, (short)1, 7567L);
            try {
                DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("unexpected InterruptedException during waitReplication: " + e));
            }
            catch (TimeoutException e) {
                Assert.fail((String)("unexpected TimeoutException during waitReplication: " + e));
            }
            fsIn = fs.open(TEST_PATH);
            byte[] original = new byte[TEST_FILE_LENGTH];
            IOUtils.readFully((InputStream)fsIn, (byte[])original, (int)0, (int)TEST_FILE_LENGTH);
            fsIn.close();
            fsIn = fs.open(TEST_PATH);
            HdfsDataInputStream dfsIn = (HdfsDataInputStream)fsIn;
            try {
                result = dfsIn.read(null, BLOCK_SIZE + 1, EnumSet.noneOf(ReadOption.class));
                Assert.fail((String)"expected UnsupportedOperationException");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            result = dfsIn.read(null, BLOCK_SIZE, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
            Assert.assertEquals((long)BLOCK_SIZE, (long)result.remaining());
            Assert.assertEquals((long)BLOCK_SIZE, (long)dfsIn.getReadStatistics().getTotalBytesRead());
            Assert.assertEquals((long)BLOCK_SIZE, (long)dfsIn.getReadStatistics().getTotalZeroCopyBytesRead());
            Assert.assertArrayEquals((byte[])Arrays.copyOfRange(original, 0, BLOCK_SIZE), (byte[])TestEnhancedByteBufferAccess.byteBufferToArray(result));
        }
        finally {
            if (fsIn != null) {
                fsIn.close();
            }
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testZeroCopyMmapCache() throws Exception {
        HdfsConfiguration conf = TestEnhancedByteBufferAccess.initZeroCopyTest();
        MiniDFSCluster cluster = null;
        Path TEST_PATH = new Path("/a");
        int TEST_FILE_LENGTH = 5 * BLOCK_SIZE;
        int RANDOM_SEED = 23453;
        String CONTEXT = "testZeroCopyMmapCacheContext";
        FSDataInputStream fsIn = null;
        ByteBuffer[] results = new ByteBuffer[]{null, null, null, null};
        DistributedFileSystem fs = null;
        conf.set("dfs.client.context", "testZeroCopyMmapCacheContext");
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
        DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, TEST_FILE_LENGTH, (short)1, 23453L);
        try {
            DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
        }
        catch (InterruptedException e) {
            Assert.fail((String)("unexpected InterruptedException during waitReplication: " + e));
        }
        catch (TimeoutException e) {
            Assert.fail((String)("unexpected TimeoutException during waitReplication: " + e));
        }
        fsIn = fs.open(TEST_PATH);
        byte[] original = new byte[TEST_FILE_LENGTH];
        IOUtils.readFully((InputStream)fsIn, (byte[])original, (int)0, (int)TEST_FILE_LENGTH);
        fsIn.close();
        fsIn = fs.open(TEST_PATH);
        final ShortCircuitCache cache = ClientContext.get((String)"testZeroCopyMmapCacheContext", (DfsClientConf)new DfsClientConf((Configuration)conf)).getShortCircuitCache();
        cache.accept((ShortCircuitCache.CacheVisitor)new CountingVisitor(0, 5, 5, 0));
        results[0] = fsIn.read(null, BLOCK_SIZE, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
        fsIn.seek(0L);
        results[1] = fsIn.read(null, BLOCK_SIZE, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
        final ExtendedBlock firstBlock = DFSTestUtil.getFirstBlock((FileSystem)fs, TEST_PATH);
        cache.accept(new ShortCircuitCache.CacheVisitor(){

            public void visit(int numOutstandingMmaps, Map<ExtendedBlockId, ShortCircuitReplica> replicas, Map<ExtendedBlockId, SecretManager.InvalidToken> failedLoads, LinkedMap evictable, LinkedMap evictableMmapped) {
                ShortCircuitReplica replica = replicas.get(new ExtendedBlockId(firstBlock.getBlockId(), firstBlock.getBlockPoolId()));
                Assert.assertNotNull((Object)replica);
                Assert.assertTrue((boolean)replica.hasMmap());
                Assert.assertNull((Object)replica.getEvictableTimeNs());
            }
        });
        results[2] = fsIn.read(null, BLOCK_SIZE, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
        results[3] = fsIn.read(null, BLOCK_SIZE, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
        cache.accept((ShortCircuitCache.CacheVisitor)new CountingVisitor(3, 5, 2, 0));
        for (ByteBuffer buffer : results) {
            if (buffer == null) continue;
            fsIn.releaseBuffer(buffer);
        }
        fsIn.close();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                final MutableBoolean finished = new MutableBoolean(false);
                cache.accept(new ShortCircuitCache.CacheVisitor(){

                    public void visit(int numOutstandingMmaps, Map<ExtendedBlockId, ShortCircuitReplica> replicas, Map<ExtendedBlockId, SecretManager.InvalidToken> failedLoads, LinkedMap evictable, LinkedMap evictableMmapped) {
                        finished.setValue(evictableMmapped.isEmpty());
                    }
                });
                return finished.booleanValue();
            }
        }, (int)10, (int)60000);
        cache.accept((ShortCircuitCache.CacheVisitor)new CountingVisitor(0, -1, -1, -1));
        fs.close();
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHdfsFallbackReads() throws Exception {
        HdfsConfiguration conf = TestEnhancedByteBufferAccess.initZeroCopyTest();
        MiniDFSCluster cluster = null;
        Path TEST_PATH = new Path("/a");
        int TEST_FILE_LENGTH = 16385;
        int RANDOM_SEED = 23453;
        FSDataInputStream fsIn = null;
        DistributedFileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 16385L, (short)1, 23453L);
            try {
                DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("unexpected InterruptedException during waitReplication: " + e));
            }
            catch (TimeoutException e) {
                Assert.fail((String)("unexpected TimeoutException during waitReplication: " + e));
            }
            fsIn = fs.open(TEST_PATH);
            byte[] original = new byte[16385];
            IOUtils.readFully((InputStream)fsIn, (byte[])original, (int)0, (int)16385);
            fsIn.close();
            fsIn = fs.open(TEST_PATH);
            TestEnhancedByteBufferAccess.testFallbackImpl((InputStream)fsIn, original);
        }
        finally {
            if (fsIn != null) {
                fsIn.close();
            }
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static void testFallbackImpl(InputStream stream, byte[] original) throws Exception {
        RestrictedAllocatingByteBufferPool bufferPool = new RestrictedAllocatingByteBufferPool(stream instanceof ByteBufferReadable);
        ByteBuffer result = ByteBufferUtil.fallbackRead((InputStream)stream, (ByteBufferPool)bufferPool, (int)10);
        Assert.assertEquals((long)10L, (long)result.remaining());
        Assert.assertArrayEquals((byte[])Arrays.copyOfRange(original, 0, 10), (byte[])TestEnhancedByteBufferAccess.byteBufferToArray(result));
        result = ByteBufferUtil.fallbackRead((InputStream)stream, (ByteBufferPool)bufferPool, (int)5000);
        Assert.assertEquals((long)5000L, (long)result.remaining());
        Assert.assertArrayEquals((byte[])Arrays.copyOfRange(original, 10, 5010), (byte[])TestEnhancedByteBufferAccess.byteBufferToArray(result));
        result = ByteBufferUtil.fallbackRead((InputStream)stream, (ByteBufferPool)bufferPool, (int)9999999);
        Assert.assertEquals((long)11375L, (long)result.remaining());
        Assert.assertArrayEquals((byte[])Arrays.copyOfRange(original, 5010, 16385), (byte[])TestEnhancedByteBufferAccess.byteBufferToArray(result));
        result = ByteBufferUtil.fallbackRead((InputStream)stream, (ByteBufferPool)bufferPool, (int)10);
        Assert.assertNull((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFallbackRead() throws Exception {
        HdfsConfiguration conf = TestEnhancedByteBufferAccess.initZeroCopyTest();
        MiniDFSCluster cluster = null;
        Path TEST_PATH = new Path("/a");
        int TEST_FILE_LENGTH = 16385;
        int RANDOM_SEED = 23453;
        FSDataInputStream fsIn = null;
        DistributedFileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 16385L, (short)1, 23453L);
            try {
                DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("unexpected InterruptedException during waitReplication: " + e));
            }
            catch (TimeoutException e) {
                Assert.fail((String)("unexpected TimeoutException during waitReplication: " + e));
            }
            fsIn = fs.open(TEST_PATH);
            byte[] original = new byte[16385];
            IOUtils.readFully((InputStream)fsIn, (byte[])original, (int)0, (int)16385);
            fsIn.close();
            fsIn = fs.open(TEST_PATH);
            TestEnhancedByteBufferAccess.testFallbackImpl((InputStream)fsIn, original);
        }
        finally {
            if (fsIn != null) {
                fsIn.close();
            }
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndirectFallbackReads() throws Exception {
        File TEST_DIR = new File(System.getProperty("test.build.data", "build/test/data"));
        String TEST_PATH = TEST_DIR + File.separator + "indirectFallbackTestFile";
        int TEST_FILE_LENGTH = 16385;
        int RANDOM_SEED = 23453;
        FileOutputStream fos = null;
        FileInputStream fis = null;
        try {
            fos = new FileOutputStream(TEST_PATH);
            Random random = new Random(23453L);
            byte[] original = new byte[16385];
            random.nextBytes(original);
            fos.write(original);
            fos.close();
            fos = null;
            fis = new FileInputStream(TEST_PATH);
            TestEnhancedByteBufferAccess.testFallbackImpl(fis, original);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fos, fis});
            new File(TEST_PATH).delete();
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fos, fis});
        new File(TEST_PATH).delete();
    }

    @Test(timeout=120000L)
    public void testZeroCopyReadOfCachedData() throws Exception {
        BlockReaderTestUtil.enableShortCircuitShmTracing();
        BlockReaderTestUtil.enableBlockReaderFactoryTracing();
        BlockReaderTestUtil.enableHdfsCachingTracing();
        int TEST_FILE_LENGTH = BLOCK_SIZE;
        Path TEST_PATH = new Path("/a");
        int RANDOM_SEED = 23453;
        HdfsConfiguration conf = TestEnhancedByteBufferAccess.initZeroCopyTest();
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", false);
        String CONTEXT = "testZeroCopyReadOfCachedData";
        conf.set("dfs.client.context", "testZeroCopyReadOfCachedData");
        conf.setLong("dfs.datanode.max.locked.memory", DFSTestUtil.roundUpToMultiple(TEST_FILE_LENGTH, (int)NativeIO.POSIX.getCacheManipulator().getOperatingSystemPageSize()));
        MiniDFSCluster cluster = null;
        ByteBuffer result = null;
        ByteBuffer result2 = null;
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        FsDatasetSpi fsd = cluster.getDataNodes().get(0).getFSDataset();
        DistributedFileSystem fs = cluster.getFileSystem();
        DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, TEST_FILE_LENGTH, (short)1, 23453L);
        DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
        byte[] original = DFSTestUtil.calculateFileContentsFromSeed(23453L, TEST_FILE_LENGTH);
        FSDataInputStream fsIn = fs.open(TEST_PATH);
        try {
            result = fsIn.read(null, TEST_FILE_LENGTH / 2, EnumSet.noneOf(ReadOption.class));
            Assert.fail((String)"expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        fs.addCachePool(new CachePoolInfo("pool1"));
        long directiveId = fs.addCacheDirective(new CacheDirectiveInfo.Builder().setPath(TEST_PATH).setReplication(Short.valueOf((short)1)).setPool("pool1").build());
        int numBlocks = (int)Math.ceil((double)TEST_FILE_LENGTH / (double)BLOCK_SIZE);
        DFSTestUtil.verifyExpectedCacheUsage(DFSTestUtil.roundUpToMultiple(TEST_FILE_LENGTH, BLOCK_SIZE), numBlocks, cluster.getDataNodes().get(0).getFSDataset());
        try {
            result = fsIn.read(null, TEST_FILE_LENGTH, EnumSet.noneOf(ReadOption.class));
        }
        catch (UnsupportedOperationException e) {
            Assert.fail((String)"expected to be able to read cached file via zero-copy");
        }
        Assert.assertArrayEquals((byte[])Arrays.copyOfRange(original, 0, BLOCK_SIZE), (byte[])TestEnhancedByteBufferAccess.byteBufferToArray(result));
        FSDataInputStream fsIn2 = fs.open(TEST_PATH);
        try {
            result2 = fsIn2.read(null, TEST_FILE_LENGTH, EnumSet.noneOf(ReadOption.class));
        }
        catch (UnsupportedOperationException e) {
            Assert.fail((String)"expected to be able to read cached file via zero-copy");
        }
        Assert.assertArrayEquals((byte[])Arrays.copyOfRange(original, 0, BLOCK_SIZE), (byte[])TestEnhancedByteBufferAccess.byteBufferToArray(result2));
        fsIn2.releaseBuffer(result2);
        fsIn2.close();
        ExtendedBlock firstBlock = DFSTestUtil.getFirstBlock((FileSystem)fs, TEST_PATH);
        ShortCircuitCache cache = ClientContext.get((String)"testZeroCopyReadOfCachedData", (DfsClientConf)new DfsClientConf((Configuration)conf)).getShortCircuitCache();
        this.waitForReplicaAnchorStatus(cache, firstBlock, true, true, 1);
        fs.removeCacheDirective(directiveId);
        this.waitForReplicaAnchorStatus(cache, firstBlock, false, true, 1);
        fsIn.releaseBuffer(result);
        this.waitForReplicaAnchorStatus(cache, firstBlock, false, false, 1);
        DFSTestUtil.verifyExpectedCacheUsage(0L, 0L, fsd);
        fsIn.close();
        fs.close();
        cluster.shutdown();
    }

    private void waitForReplicaAnchorStatus(final ShortCircuitCache cache, final ExtendedBlock block, final boolean expectedIsAnchorable, final boolean expectedIsAnchored, final int expectedOutstandingMmaps) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                final MutableBoolean result = new MutableBoolean(false);
                cache.accept(new ShortCircuitCache.CacheVisitor(){

                    public void visit(int numOutstandingMmaps, Map<ExtendedBlockId, ShortCircuitReplica> replicas, Map<ExtendedBlockId, SecretManager.InvalidToken> failedLoads, LinkedMap evictable, LinkedMap evictableMmapped) {
                        Assert.assertEquals((long)expectedOutstandingMmaps, (long)numOutstandingMmaps);
                        ShortCircuitReplica replica = replicas.get(ExtendedBlockId.fromExtendedBlock((ExtendedBlock)block));
                        Assert.assertNotNull((Object)replica);
                        ShortCircuitShm.Slot slot = replica.getSlot();
                        if (expectedIsAnchorable != slot.isAnchorable() || expectedIsAnchored != slot.isAnchored()) {
                            LOG.info((Object)("replica " + replica + " has isAnchorable = " + slot.isAnchorable() + ", isAnchored = " + slot.isAnchored() + ".  Waiting for isAnchorable = " + expectedIsAnchorable + ", isAnchored = " + expectedIsAnchored));
                            return;
                        }
                        result.setValue(true);
                    }
                });
                return result.toBoolean();
            }
        }, (int)10, (int)60000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientMmapDisable() throws Exception {
        HdfsConfiguration conf = TestEnhancedByteBufferAccess.initZeroCopyTest();
        conf.setBoolean("dfs.client.mmap.enabled", false);
        MiniDFSCluster cluster = null;
        Path TEST_PATH = new Path("/a");
        int TEST_FILE_LENGTH = 16385;
        int RANDOM_SEED = 23453;
        String CONTEXT = "testClientMmapDisable";
        FSDataInputStream fsIn = null;
        DistributedFileSystem fs = null;
        conf.set("dfs.client.context", "testClientMmapDisable");
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 16385L, (short)1, 23453L);
            DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            fsIn = fs.open(TEST_PATH);
            try {
                fsIn.read(null, 1, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
                Assert.fail((String)"expected zero-copy read to fail when client mmaps were disabled.");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        finally {
            if (fsIn != null) {
                fsIn.close();
            }
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        fsIn = null;
        fs = null;
        cluster = null;
        try {
            conf.setBoolean("dfs.client.mmap.enabled", true);
            conf.setInt("dfs.client.mmap.cache.size", 0);
            conf.set("dfs.client.context", "testClientMmapDisable.1");
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 16385L, (short)1, 23453L);
            DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            fsIn = fs.open(TEST_PATH);
            ByteBuffer buf = fsIn.read(null, 1, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
            fsIn.releaseBuffer(buf);
            IOUtils.skipFully((InputStream)fsIn, (long)16384L);
            buf = fsIn.read(null, 1, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
            Assert.assertEquals(null, (Object)buf);
        }
        finally {
            if (fsIn != null) {
                fsIn.close();
            }
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2GBMmapLimit() throws Exception {
        ByteBuffer buf2;
        FSDataInputStream fsIn2;
        FSDataInputStream fsIn;
        MiniDFSCluster cluster;
        block9: {
            Assume.assumeTrue((boolean)BlockReaderTestUtil.shouldTestLargeFiles());
            HdfsConfiguration conf = TestEnhancedByteBufferAccess.initZeroCopyTest();
            long TEST_FILE_LENGTH = 2469605888L;
            conf.set("dfs.checksum.type", "NULL");
            conf.setLong("dfs.blocksize", 2469605888L);
            cluster = null;
            Path TEST_PATH = new Path("/a");
            String CONTEXT = "test2GBMmapLimit";
            conf.set("dfs.client.context", "test2GBMmapLimit");
            fsIn = null;
            fsIn2 = null;
            ByteBuffer buf1 = null;
            buf2 = null;
            try {
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
                cluster.waitActive();
                DistributedFileSystem fs = cluster.getFileSystem();
                DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 2469605888L, (short)1, 11L);
                DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
                fsIn = fs.open(TEST_PATH);
                buf1 = fsIn.read(null, 1, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
                Assert.assertEquals((long)1L, (long)buf1.remaining());
                fsIn.releaseBuffer(buf1);
                buf1 = null;
                fsIn.seek(0x7FFFFFF8L);
                buf1 = fsIn.read(null, 1024, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
                Assert.assertEquals((long)7L, (long)buf1.remaining());
                Assert.assertEquals((long)Integer.MAX_VALUE, (long)buf1.limit());
                fsIn.releaseBuffer(buf1);
                buf1 = null;
                Assert.assertEquals((long)Integer.MAX_VALUE, (long)fsIn.getPos());
                try {
                    buf1 = fsIn.read(null, 1024, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
                    Assert.fail((String)"expected UnsupportedOperationException");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                fsIn.close();
                fsIn = null;
                Path TEST_PATH2 = new Path("/b");
                conf.setLong("dfs.blocksize", 0x10000000L);
                DFSTestUtil.createFile((FileSystem)fs, TEST_PATH2, 0x100000, 2469605888L, 0x10000000L, (short)1, 10L);
                fsIn2 = fs.open(TEST_PATH2);
                fsIn2.seek(0x7FFFFFF8L);
                buf2 = fsIn2.read(null, 1024, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
                Assert.assertEquals((long)8L, (long)buf2.remaining());
                Assert.assertEquals((long)0x80000000L, (long)fsIn2.getPos());
                fsIn2.releaseBuffer(buf2);
                buf2 = null;
                buf2 = fsIn2.read(null, 1024, EnumSet.of(ReadOption.SKIP_CHECKSUMS));
                Assert.assertEquals((long)1024L, (long)buf2.remaining());
                Assert.assertEquals((long)0x80000400L, (long)fsIn2.getPos());
                fsIn2.releaseBuffer(buf2);
                buf2 = null;
                if (buf1 == null) break block9;
            }
            catch (Throwable throwable) {
                if (buf1 != null) {
                    fsIn.releaseBuffer(buf1);
                }
                if (buf2 != null) {
                    fsIn2.releaseBuffer(buf2);
                }
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{fsIn, fsIn2});
                if (cluster != null) {
                    cluster.shutdown();
                }
                throw throwable;
            }
            fsIn.releaseBuffer(buf1);
        }
        if (buf2 != null) {
            fsIn2.releaseBuffer(buf2);
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fsIn, fsIn2});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    static {
        BLOCK_SIZE = (int)NativeIO.POSIX.getCacheManipulator().getOperatingSystemPageSize();
    }

    private static class RestrictedAllocatingByteBufferPool
    implements ByteBufferPool {
        private final boolean direct;

        RestrictedAllocatingByteBufferPool(boolean direct) {
            this.direct = direct;
        }

        public ByteBuffer getBuffer(boolean direct, int length) {
            Preconditions.checkArgument((this.direct == direct ? 1 : 0) != 0);
            return direct ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
        }

        public void putBuffer(ByteBuffer buffer) {
        }
    }

    private static class CountingVisitor
    implements ShortCircuitCache.CacheVisitor {
        private final int expectedNumOutstandingMmaps;
        private final int expectedNumReplicas;
        private final int expectedNumEvictable;
        private final int expectedNumMmapedEvictable;

        CountingVisitor(int expectedNumOutstandingMmaps, int expectedNumReplicas, int expectedNumEvictable, int expectedNumMmapedEvictable) {
            this.expectedNumOutstandingMmaps = expectedNumOutstandingMmaps;
            this.expectedNumReplicas = expectedNumReplicas;
            this.expectedNumEvictable = expectedNumEvictable;
            this.expectedNumMmapedEvictable = expectedNumMmapedEvictable;
        }

        public void visit(int numOutstandingMmaps, Map<ExtendedBlockId, ShortCircuitReplica> replicas, Map<ExtendedBlockId, SecretManager.InvalidToken> failedLoads, LinkedMap evictable, LinkedMap evictableMmapped) {
            if (this.expectedNumOutstandingMmaps >= 0) {
                Assert.assertEquals((long)this.expectedNumOutstandingMmaps, (long)numOutstandingMmaps);
            }
            if (this.expectedNumReplicas >= 0) {
                Assert.assertEquals((long)this.expectedNumReplicas, (long)replicas.size());
            }
            if (this.expectedNumEvictable >= 0) {
                Assert.assertEquals((long)this.expectedNumEvictable, (long)evictable.size());
            }
            if (this.expectedNumMmapedEvictable >= 0) {
                Assert.assertEquals((long)this.expectedNumMmapedEvictable, (long)evictableMmapped.size());
            }
        }
    }
}

