/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;

public class TestAppendDifferentChecksum {
    private static final int SEGMENT_LENGTH = 1500;
    private static final long RANDOM_TEST_RUNTIME = 5000L;
    private static MiniDFSCluster cluster;
    private static FileSystem fs;

    @BeforeClass
    public static void setupCluster() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.blocksize", 4096);
        conf.set("fs.hdfs.impl.disable.cache", "true");
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        fs = cluster.getFileSystem();
    }

    @AfterClass
    public static void teardown() throws IOException {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    @Ignore(value="this is not implemented! See HDFS-2130")
    public void testSwitchChunkSize() throws IOException {
        FileSystem fsWithSmallChunk = this.createFsWithChecksum("CRC32", 512);
        FileSystem fsWithBigChunk = this.createFsWithChecksum("CRC32", 1024);
        Path p = new Path("/testSwitchChunkSize");
        this.appendWithTwoFs(p, fsWithSmallChunk, fsWithBigChunk);
        AppendTestUtil.check(fsWithSmallChunk, p, 3000L);
        AppendTestUtil.check(fsWithBigChunk, p, 3000L);
    }

    @Test
    public void testSwitchAlgorithms() throws IOException {
        FileSystem fsWithCrc32 = this.createFsWithChecksum("CRC32", 512);
        FileSystem fsWithCrc32C = this.createFsWithChecksum("CRC32C", 512);
        Path p = new Path("/testSwitchAlgorithms");
        this.appendWithTwoFs(p, fsWithCrc32, fsWithCrc32C);
        AppendTestUtil.check(fsWithCrc32C, p, 3000L);
        AppendTestUtil.check(fsWithCrc32, p, 3000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAlgoSwitchRandomized() throws IOException {
        FileSystem fsWithCrc32 = this.createFsWithChecksum("CRC32", 512);
        FileSystem fsWithCrc32C = this.createFsWithChecksum("CRC32C", 512);
        Path p = new Path("/testAlgoSwitchRandomized");
        long seed = Time.now();
        System.out.println("seed: " + seed);
        Random r = new Random(seed);
        IOUtils.closeStream((Closeable)fsWithCrc32.create(p));
        long st = Time.now();
        int len = 0;
        while (Time.now() - st < 5000L) {
            int thisLen = r.nextInt(500);
            FileSystem fs = r.nextBoolean() ? fsWithCrc32 : fsWithCrc32C;
            try (FSDataOutputStream stm = fs.append(p);){
                AppendTestUtil.write((OutputStream)stm, len, thisLen);
            }
            len += thisLen;
        }
        AppendTestUtil.check(fsWithCrc32, p, len);
        AppendTestUtil.check(fsWithCrc32C, p, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testChecksumErrorAppendWhileTransfer() throws Exception {
        DataNodeFaultInjector oldFi = DataNodeFaultInjector.get();
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs((Logger)DataNode.LOG);
        try {
            Path f = new Path("/f");
            try (FSDataOutputStream o = fs.create(f, false, 1024, (short)1, 0x8000000L);){
                AppendTestUtil.write((OutputStream)o, 0, 66136);
            }
            final CountDownLatch latch = new CountDownLatch(2);
            DataNodeFaultInjector.set((DataNodeFaultInjector)new DataNodeFaultInjector(){

                public void waitForBlockSenderMetaInputStreamBeforeAppend() throws IOException {
                    latch.countDown();
                    try {
                        latch.await(20L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            cluster.startDataNodes(cluster.getConfiguration(0), 1, true, null, null);
            fs.setReplication(f, (short)2);
            while (latch.getCount() > 1L) {
                Thread.sleep(100L);
            }
            o = fs.append(f);
            try {
                AppendTestUtil.write((OutputStream)o, 0, 1);
                o.hflush();
                latch.countDown();
                final ExtendedBlock b = cluster.getFileSystem().getClient().getLocatedBlocks(f.toString(), 0L).get(0).getBlock();
                GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                    public Boolean get() {
                        return cluster.getDataNodes().get(1).getFSDataset().contains(b);
                    }
                }, (int)100, (int)600);
            }
            finally {
                o.close();
            }
        }
        finally {
            DataNodeFaultInjector.set((DataNodeFaultInjector)oldFi);
            String logs = logCapturer.getOutput();
            logCapturer.stopCapturing();
            Assert.assertFalse((String)"There should not be any checkum exception thrown", (boolean)logs.contains("ChecksumException"));
        }
    }

    private FileSystem createFsWithChecksum(String type, int bytes) throws IOException {
        Configuration conf = new Configuration(fs.getConf());
        conf.set("dfs.checksum.type", type);
        conf.setInt("dfs.bytes-per-checksum", bytes);
        return FileSystem.get((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendWithTwoFs(Path p, FileSystem fs1, FileSystem fs2) throws IOException {
        try (FSDataOutputStream stm = fs1.create(p);){
            AppendTestUtil.write((OutputStream)stm, 0, 1500);
        }
        stm = fs2.append(p);
        try {
            AppendTestUtil.write((OutputStream)stm, 1500, 1500);
        }
        finally {
            stm.close();
        }
    }
}

