/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.junit.Assert;
import org.junit.Test;

public class TestDataNodeUUID {
    @Test
    public void testDatanodeUuid() throws Exception {
        InetSocketAddress NN_ADDR = new InetSocketAddress("localhost", 5020);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.datanode.address", "0.0.0.0:0");
        conf.set("dfs.datanode.http.address", "0.0.0.0:0");
        conf.set("dfs.datanode.ipc.address", "0.0.0.0:0");
        FileSystem.setDefaultUri((Configuration)conf, (String)("hdfs://" + NN_ADDR.getHostName() + ":" + NN_ADDR.getPort()));
        ArrayList locations = new ArrayList();
        DataNode dn = new DataNode((Configuration)conf, locations, null);
        Object nullString = null;
        Assert.assertEquals((Object)dn.getDatanodeUuid(), nullString);
        dn.checkDatanodeUuid();
        Assert.assertNotEquals((Object)dn.getDatanodeUuid(), nullString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testUUIDRegeneration() throws Exception {
        File baseDir = new File(System.getProperty("test.build.data"));
        File disk1 = new File(baseDir, "disk1");
        File disk2 = new File(baseDir, "disk2");
        FileUtils.deleteDirectory((File)disk1);
        FileUtils.deleteDirectory((File)disk2);
        MiniDFSCluster cluster = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setStrings("dfs.datanode.data.dir", new String[]{disk1.toURI().toString(), disk2.toURI().toString()});
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).manageDataDfsDirs(false).build();
            cluster.waitActive();
            String originalUUID = cluster.getDataNodes().get(0).getDatanodeUuid();
            MiniDFSCluster.DataNodeProperties dn = cluster.stopDataNode(0);
            FileUtils.deleteDirectory((File)disk2);
            Assert.assertTrue((String)("Failed to recreate the data directory: " + disk2), (boolean)disk2.mkdirs());
            Assert.assertTrue((String)("DataNode failed to start up: " + dn), (boolean)cluster.restartDataNode(dn));
            while (!cluster.getDataNodes().get(0).isDatanodeFullyStarted()) {
                Thread.sleep(50L);
            }
            Assert.assertEquals((String)"DN generated a new UUID despite disk1 having it intact", (Object)originalUUID, (Object)cluster.getDataNodes().get(0).getDatanodeUuid());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

