/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ha.ClientBaseWithFixes;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HealthMonitor;
import org.apache.hadoop.ha.TestNodeFencer;
import org.apache.hadoop.ha.ZKFCTestUtil;
import org.apache.hadoop.ha.ZKFailoverController;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.MockNameNodeResourceChecker;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeResourceChecker;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.tools.DFSHAAdmin;
import org.apache.hadoop.hdfs.tools.DFSZKFailoverController;
import org.apache.hadoop.net.ServerSocketUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDFSZKFailoverController
extends ClientBaseWithFixes {
    private static final String LOCALHOST_SERVER_ADDRESS = "127.0.0.1";
    private static final String WILDCARD_ADDRESS = "0.0.0.0";
    private Configuration conf;
    private MiniDFSCluster cluster;
    private MultithreadedTestUtil.TestContext ctx;
    private ZKFCThread thr1;
    private ZKFCThread thr2;
    private FileSystem fs;

    @Before
    public void setup() throws Exception {
        this.conf = new Configuration();
        this.conf.set("ha.zookeeper.quorum.ns1", this.hostPort);
        this.conf.set("dfs.ha.fencing.methods", TestNodeFencer.AlwaysSucceedFencer.class.getName());
        this.conf.setBoolean("dfs.ha.automatic-failover.enabled", true);
        this.conf.setInt("ipc.client.connection.maxidletime", 0);
        this.conf.setInt("dfs.ha.zkfc.port.ns1.nn1", ServerSocketUtil.getPort((int)10023, (int)100));
        this.conf.setInt("dfs.ha.zkfc.port.ns1.nn2", ServerSocketUtil.getPort((int)10024, (int)100));
        MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ns1").addNN(new MiniDFSNNTopology.NNConf("nn1").setIpcPort(ServerSocketUtil.getPort((int)10021, (int)100))).addNN(new MiniDFSNNTopology.NNConf("nn2").setIpcPort(ServerSocketUtil.getPort((int)10022, (int)100))));
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(topology).numDataNodes(0).build();
        this.cluster.waitActive();
        this.ctx = new MultithreadedTestUtil.TestContext();
        this.thr1 = new ZKFCThread(this.ctx, 0);
        this.ctx.addThread((MultithreadedTestUtil.TestingThread)this.thr1);
        Assert.assertEquals((long)0L, (long)this.thr1.zkfc.run(new String[]{"-formatZK"}));
        this.thr1.start();
        this.waitForHAState(0, HAServiceProtocol.HAServiceState.ACTIVE);
        this.thr2 = new ZKFCThread(this.ctx, 1);
        this.ctx.addThread((MultithreadedTestUtil.TestingThread)this.thr2);
        this.thr2.start();
        ZKFCTestUtil.waitForHealthState((ZKFailoverController)this.thr1.zkfc, (HealthMonitor.State)HealthMonitor.State.SERVICE_HEALTHY, (MultithreadedTestUtil.TestContext)this.ctx);
        ZKFCTestUtil.waitForHealthState((ZKFailoverController)this.thr2.zkfc, (HealthMonitor.State)HealthMonitor.State.SERVICE_HEALTHY, (MultithreadedTestUtil.TestContext)this.ctx);
        this.fs = HATestUtil.configureFailoverFs(this.cluster, this.conf);
    }

    @After
    public void shutdown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        if (this.thr1 != null) {
            this.thr1.interrupt();
            this.thr1 = null;
        }
        if (this.thr2 != null) {
            this.thr2.interrupt();
            this.thr2 = null;
        }
        if (this.ctx != null) {
            this.ctx.stop();
            this.ctx = null;
        }
    }

    @Test(timeout=60000L)
    public void testThreadDumpCaptureAfterNNStateChange() throws Exception {
        MockNameNodeResourceChecker mockResourceChecker = new MockNameNodeResourceChecker(this.conf);
        mockResourceChecker.setResourcesAvailable(false);
        this.cluster.getNameNode(0).getNamesystem().setNNResourceChecker((NameNodeResourceChecker)mockResourceChecker);
        this.waitForHAState(0, HAServiceProtocol.HAServiceState.STANDBY);
        while (!this.thr1.zkfc.isThreadDumpCaptured()) {
            Thread.sleep(1000L);
        }
    }

    @Test(timeout=60000L)
    public void testFailoverAndBackOnNNShutdown() throws Exception {
        Path p1 = new Path("/dir1");
        Path p2 = new Path("/dir2");
        this.fs.mkdirs(p1);
        this.cluster.shutdownNameNode(0);
        Assert.assertTrue((boolean)this.fs.exists(p1));
        this.fs.mkdirs(p2);
        Assert.assertEquals((Object)TestNodeFencer.AlwaysSucceedFencer.getLastFencedService().getAddress(), (Object)this.thr1.zkfc.getLocalTarget().getAddress());
        this.cluster.restartNameNode(0);
        this.waitForHAState(0, HAServiceProtocol.HAServiceState.STANDBY);
        Assert.assertTrue((boolean)this.fs.exists(p1));
        Assert.assertTrue((boolean)this.fs.exists(p2));
        this.cluster.shutdownNameNode(1);
        this.waitForHAState(0, HAServiceProtocol.HAServiceState.ACTIVE);
        Assert.assertTrue((boolean)this.fs.exists(p1));
        Assert.assertTrue((boolean)this.fs.exists(p2));
        Assert.assertEquals((Object)TestNodeFencer.AlwaysSucceedFencer.getLastFencedService().getAddress(), (Object)this.thr2.zkfc.getLocalTarget().getAddress());
    }

    @Test(timeout=30000L)
    public void testManualFailover() throws Exception {
        this.thr2.zkfc.getLocalTarget().getZKFCProxy(this.conf, 15000).gracefulFailover();
        this.waitForHAState(0, HAServiceProtocol.HAServiceState.STANDBY);
        this.waitForHAState(1, HAServiceProtocol.HAServiceState.ACTIVE);
        this.thr1.zkfc.getLocalTarget().getZKFCProxy(this.conf, 15000).gracefulFailover();
        this.waitForHAState(0, HAServiceProtocol.HAServiceState.ACTIVE);
        this.waitForHAState(1, HAServiceProtocol.HAServiceState.STANDBY);
    }

    @Test(timeout=30000L)
    public void testWithoutBindAddressSet() throws Exception {
        DFSZKFailoverController zkfc = DFSZKFailoverController.create((Configuration)this.conf);
        Assert.assertEquals((String)"Bind address not expected to be wildcard by default.", (Object)zkfc.getRpcAddressToBindTo().getHostString(), (Object)LOCALHOST_SERVER_ADDRESS);
    }

    @Test(timeout=30000L)
    public void testWithBindAddressSet() throws Exception {
        this.conf.set("dfs.namenode.servicerpc-bind-host", WILDCARD_ADDRESS);
        DFSZKFailoverController zkfc = DFSZKFailoverController.create((Configuration)this.conf);
        String addr = zkfc.getRpcAddressToBindTo().getHostString();
        Assert.assertEquals((String)("Bind address " + addr + " is not wildcard."), (Object)addr, (Object)WILDCARD_ADDRESS);
    }

    @Test(timeout=30000L)
    public void testManualFailoverWithDFSHAAdmin() throws Exception {
        DFSHAAdmin tool = new DFSHAAdmin();
        tool.setConf(this.conf);
        Assert.assertEquals((long)0L, (long)tool.run(new String[]{"-failover", "nn1", "nn2"}));
        this.waitForHAState(0, HAServiceProtocol.HAServiceState.STANDBY);
        this.waitForHAState(1, HAServiceProtocol.HAServiceState.ACTIVE);
        Assert.assertEquals((long)0L, (long)tool.run(new String[]{"-failover", "nn2", "nn1"}));
        this.waitForHAState(0, HAServiceProtocol.HAServiceState.ACTIVE);
        this.waitForHAState(1, HAServiceProtocol.HAServiceState.STANDBY);
    }

    private void waitForHAState(int nnidx, final HAServiceProtocol.HAServiceState state) throws TimeoutException, InterruptedException {
        final NameNode nn = this.cluster.getNameNode(nnidx);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    return nn.getRpcServer().getServiceStatus().getState() == state;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }, (long)50L, (long)15000L);
    }

    static {
        EditLogFileOutputStream.setShouldSkipFsyncForTesting((boolean)true);
    }

    private class ZKFCThread
    extends MultithreadedTestUtil.TestingThread {
        private final DFSZKFailoverController zkfc;

        public ZKFCThread(MultithreadedTestUtil.TestContext ctx, int idx) {
            super(ctx);
            this.zkfc = DFSZKFailoverController.create((Configuration)TestDFSZKFailoverController.this.cluster.getConfiguration(idx));
        }

        public void doWork() throws Exception {
            try {
                Assert.assertEquals((long)0L, (long)this.zkfc.run(new String[0]));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

