/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.nodelabels;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.nodelabels.RMNodeLabel;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeLabelsUpdateSchedulerEvent;
import org.apache.hadoop.yarn.util.resource.Resources;

public class RMNodeLabelsManager
extends CommonNodeLabelsManager {
    ConcurrentMap<String, Queue> queueCollections = new ConcurrentHashMap<String, Queue>();
    private YarnAuthorizationProvider authorizer;
    private RMContext rmContext = null;

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLabelsToNode(Map<NodeId, Set<String>> addedLabelsToNode) throws IOException {
        try {
            this.writeLock.lock();
            Map<String, CommonNodeLabelsManager.Host> before = this.cloneNodeMap(addedLabelsToNode.keySet());
            super.addLabelsToNode(addedLabelsToNode);
            Map<String, CommonNodeLabelsManager.Host> after = this.cloneNodeMap(addedLabelsToNode.keySet());
            this.updateResourceMappings(before, after);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void checkRemoveFromClusterNodeLabelsOfQueue(Collection<String> labelsToRemove) throws IOException {
        for (String label : labelsToRemove) {
            label = this.normalizeLabel(label);
            for (Map.Entry entry : this.queueCollections.entrySet()) {
                String queueName = (String)entry.getKey();
                Set<String> queueLabels = ((Queue)entry.getValue()).accessibleNodeLabels;
                if (!queueLabels.contains(label)) continue;
                throw new IOException("Cannot remove label=" + label + ", because queue=" + queueName + " is using this label. " + "Please remove label on queue before remove the label");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromClusterNodeLabels(Collection<String> labelsToRemove) throws IOException {
        try {
            this.writeLock.lock();
            if (!this.isInitNodeLabelStoreInProgress()) {
                this.checkRemoveFromClusterNodeLabelsOfQueue(labelsToRemove);
            }
            Map<String, CommonNodeLabelsManager.Host> before = this.cloneNodeMap();
            super.removeFromClusterNodeLabels(labelsToRemove);
            this.updateResourceMappings(before, this.nodeCollections);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCluserNodeLabels(Collection<NodeLabel> labels) throws IOException {
        try {
            this.writeLock.lock();
            super.addToCluserNodeLabels(labels);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLabelsFromNode(Map<NodeId, Set<String>> removeLabelsFromNode) throws IOException {
        try {
            this.writeLock.lock();
            Map<String, CommonNodeLabelsManager.Host> before = this.cloneNodeMap(removeLabelsFromNode.keySet());
            super.removeLabelsFromNode(removeLabelsFromNode);
            Map<String, CommonNodeLabelsManager.Host> after = this.cloneNodeMap(removeLabelsFromNode.keySet());
            this.updateResourceMappings(before, after);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceLabelsOnNode(Map<NodeId, Set<String>> replaceLabelsToNode) throws IOException {
        try {
            this.writeLock.lock();
            Map<NodeId, Set<String>> effectiveModifiedLabelMappings = this.getModifiedNodeLabelsMappings(replaceLabelsToNode);
            if (effectiveModifiedLabelMappings.isEmpty()) {
                LOG.info((Object)"No Modified Node label Mapping to replace");
                return;
            }
            Map<String, CommonNodeLabelsManager.Host> before = this.cloneNodeMap(effectiveModifiedLabelMappings.keySet());
            super.replaceLabelsOnNode(effectiveModifiedLabelMappings);
            Map<String, CommonNodeLabelsManager.Host> after = this.cloneNodeMap(effectiveModifiedLabelMappings.keySet());
            this.updateResourceMappings(before, after);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Map<NodeId, Set<String>> getModifiedNodeLabelsMappings(Map<NodeId, Set<String>> replaceLabelsToNode) {
        HashMap<NodeId, Set<String>> effectiveModifiedLabels = new HashMap<NodeId, Set<String>>();
        for (Map.Entry<NodeId, Set<String>> nodeLabelMappingEntry : replaceLabelsToNode.entrySet()) {
            NodeId nodeId = nodeLabelMappingEntry.getKey();
            Set<String> modifiedNodeLabels = nodeLabelMappingEntry.getValue();
            Set labelsBeforeModification = null;
            CommonNodeLabelsManager.Host host = (CommonNodeLabelsManager.Host)this.nodeCollections.get(nodeId.getHost());
            if (host == null) {
                effectiveModifiedLabels.put(nodeId, modifiedNodeLabels);
                continue;
            }
            if (nodeId.getPort() == 0) {
                labelsBeforeModification = host.labels;
            } else if (host.nms.get(nodeId) != null) {
                labelsBeforeModification = ((CommonNodeLabelsManager.Node)host.nms.get((Object)nodeId)).labels;
            }
            if (labelsBeforeModification != null && labelsBeforeModification.size() == modifiedNodeLabels.size() && labelsBeforeModification.containsAll(modifiedNodeLabels)) continue;
            effectiveModifiedLabels.put(nodeId, modifiedNodeLabels);
        }
        return effectiveModifiedLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateNode(NodeId nodeId, Resource resource) {
        try {
            this.writeLock.lock();
            Map<String, CommonNodeLabelsManager.Host> before = this.cloneNodeMap((Set<NodeId>)ImmutableSet.of((Object)nodeId));
            this.createHostIfNonExisted(nodeId.getHost());
            try {
                this.createNodeIfNonExisted(nodeId);
            }
            catch (IOException e) {
                LOG.error((Object)"This shouldn't happen, cannot get host in nodeCollection associated to the node being activated");
                this.writeLock.unlock();
                return;
            }
            CommonNodeLabelsManager.Node nm = this.getNMInNodeSet(nodeId);
            nm.resource = resource;
            nm.running = true;
            Set labelsForNode = this.getLabelsByNode(nodeId);
            if (labelsForNode != null) {
                for (String label : labelsForNode) {
                    RMNodeLabel labelInfo = (RMNodeLabel)this.labelCollections.get(label);
                    if (labelInfo == null) continue;
                    labelInfo.addNodeId(nodeId);
                }
            }
            Map<String, CommonNodeLabelsManager.Host> after = this.cloneNodeMap((Set<NodeId>)ImmutableSet.of((Object)nodeId));
            this.updateResourceMappings(before, after);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateNode(NodeId nodeId) {
        try {
            this.writeLock.lock();
            Map<String, CommonNodeLabelsManager.Host> before = this.cloneNodeMap((Set<NodeId>)ImmutableSet.of((Object)nodeId));
            CommonNodeLabelsManager.Node nm = this.getNMInNodeSet(nodeId);
            if (null != nm) {
                if (null == nm.labels) {
                    Set<String> savedNodeLabels = this.getLabelsOnNode(nodeId);
                    ((CommonNodeLabelsManager.Host)this.nodeCollections.get((Object)nodeId.getHost())).nms.remove(nodeId);
                    this.removeNodeFromLabels(nodeId, savedNodeLabels);
                } else {
                    nm.running = false;
                    nm.resource = Resource.newInstance((int)0, (int)0);
                }
            }
            Map<String, CommonNodeLabelsManager.Host> after = this.cloneNodeMap((Set<NodeId>)ImmutableSet.of((Object)nodeId));
            this.updateResourceMappings(before, after);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void updateNodeResource(NodeId node, Resource newResource) {
        this.deactivateNode(node);
        this.activateNode(node, newResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitializeQueueLabels(Map<String, Set<String>> queueToLabels) {
        try {
            this.writeLock.lock();
            this.queueCollections.clear();
            for (Map.Entry<String, Set<String>> entry : queueToLabels.entrySet()) {
                String queue = entry.getKey();
                Queue q = new Queue();
                this.queueCollections.put(queue, q);
                Set<String> labels = entry.getValue();
                if (labels.contains("*")) continue;
                q.accessibleNodeLabels.addAll(labels);
                for (CommonNodeLabelsManager.Host host : this.nodeCollections.values()) {
                    for (Map.Entry nentry : host.nms.entrySet()) {
                        NodeId nodeId = (NodeId)nentry.getKey();
                        CommonNodeLabelsManager.Node nm = (CommonNodeLabelsManager.Node)nentry.getValue();
                        if (!nm.running || !this.isNodeUsableByQueue(this.getLabelsByNode(nodeId), q)) continue;
                        Resources.addTo((Resource)q.resource, (Resource)nm.resource);
                    }
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getQueueResource(String queueName, Set<String> queueLabels, Resource clusterResource) {
        try {
            this.readLock.lock();
            if (queueLabels.contains("*")) {
                Resource resource = clusterResource;
                return resource;
            }
            Queue q = (Queue)this.queueCollections.get(queueName);
            if (null == q) {
                Resource resource = Resources.none();
                return resource;
            }
            Resource resource = q.resource;
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveNMCountPerLabel(String label) {
        if (label == null) {
            return 0;
        }
        try {
            this.readLock.lock();
            RMNodeLabel labelInfo = (RMNodeLabel)this.labelCollections.get(label);
            int n = labelInfo == null ? 0 : labelInfo.getNumActiveNMs();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getLabelsOnNode(NodeId nodeId) {
        try {
            this.readLock.lock();
            Set nodeLabels = this.getLabelsByNode(nodeId);
            Set<String> set = Collections.unmodifiableSet(nodeLabels);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsNodeLabel(String label) {
        try {
            this.readLock.lock();
            boolean bl = label != null && (label.isEmpty() || this.labelCollections.containsKey(label));
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Map<String, CommonNodeLabelsManager.Host> cloneNodeMap(Set<NodeId> nodesToCopy) {
        HashMap<String, CommonNodeLabelsManager.Host> map = new HashMap<String, CommonNodeLabelsManager.Host>();
        for (NodeId nodeId : nodesToCopy) {
            if (!map.containsKey(nodeId.getHost())) {
                CommonNodeLabelsManager.Host originalN = (CommonNodeLabelsManager.Host)this.nodeCollections.get(nodeId.getHost());
                if (null == originalN) continue;
                CommonNodeLabelsManager.Host n = originalN.copy();
                n.nms.clear();
                map.put(nodeId.getHost(), n);
            }
            CommonNodeLabelsManager.Host n = (CommonNodeLabelsManager.Host)map.get(nodeId.getHost());
            if (0 == nodeId.getPort()) {
                for (Map.Entry entry : ((CommonNodeLabelsManager.Host)this.nodeCollections.get((Object)nodeId.getHost())).nms.entrySet()) {
                    n.nms.put(entry.getKey(), ((CommonNodeLabelsManager.Node)entry.getValue()).copy());
                }
                continue;
            }
            CommonNodeLabelsManager.Node nm = this.getNMInNodeSet(nodeId);
            if (null == nm) continue;
            n.nms.put(nodeId, nm.copy());
        }
        return map;
    }

    private void updateResourceMappings(Map<String, CommonNodeLabelsManager.Host> before, Map<String, CommonNodeLabelsManager.Host> after) {
        HashSet allNMs = new HashSet();
        for (Map.Entry<String, CommonNodeLabelsManager.Host> entry : before.entrySet()) {
            allNMs.addAll(entry.getValue().nms.keySet());
        }
        for (Map.Entry<String, CommonNodeLabelsManager.Host> entry : after.entrySet()) {
            allNMs.addAll(entry.getValue().nms.keySet());
        }
        HashMap<NodeId, Set<String>> newNodeToLabelsMap = new HashMap<NodeId, Set<String>>();
        for (NodeId nodeId : allNMs) {
            CommonNodeLabelsManager.Node newNM;
            CommonNodeLabelsManager.Node oldNM = this.getNMInNodeSet(nodeId, before, true);
            if (oldNM != null) {
                Set oldLabels = this.getLabelsByNode(nodeId, before);
                if (oldLabels.isEmpty()) {
                    RMNodeLabel label = (RMNodeLabel)this.labelCollections.get("");
                    label.removeNode(oldNM.resource);
                    for (Queue q : this.queueCollections.values()) {
                        Resources.subtractFrom((Resource)q.resource, (Resource)oldNM.resource);
                    }
                } else {
                    for (String labelName : oldLabels) {
                        RMNodeLabel label = (RMNodeLabel)this.labelCollections.get(labelName);
                        if (null == label) continue;
                        label.removeNode(oldNM.resource);
                    }
                    for (Queue q : this.queueCollections.values()) {
                        if (!this.isNodeUsableByQueue(oldLabels, q)) continue;
                        Resources.subtractFrom((Resource)q.resource, (Resource)oldNM.resource);
                    }
                }
            }
            if ((newNM = this.getNMInNodeSet(nodeId, after, true)) == null) continue;
            Set newLabels = this.getLabelsByNode(nodeId, after);
            newNodeToLabelsMap.put(nodeId, (Set<String>)ImmutableSet.copyOf((Collection)newLabels));
            if (newLabels.isEmpty()) {
                RMNodeLabel label = (RMNodeLabel)this.labelCollections.get("");
                label.addNode(newNM.resource);
                for (Queue q : this.queueCollections.values()) {
                    Resources.addTo((Resource)q.resource, (Resource)newNM.resource);
                }
                continue;
            }
            for (String labelName : newLabels) {
                RMNodeLabel label = (RMNodeLabel)this.labelCollections.get(labelName);
                label.addNode(newNM.resource);
            }
            for (Queue q : this.queueCollections.values()) {
                if (!this.isNodeUsableByQueue(newLabels, q)) continue;
                Resources.addTo((Resource)q.resource, (Resource)newNM.resource);
            }
        }
        if (this.rmContext != null && this.rmContext.getDispatcher() != null) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new NodeLabelsUpdateSchedulerEvent(newNodeToLabelsMap));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResourceByLabel(String label, Resource clusterResource) {
        if ((label = this.normalizeLabel(label)).equals("")) {
            return this.noNodeLabel.getResource();
        }
        try {
            this.readLock.lock();
            RMNodeLabel nodeLabel = (RMNodeLabel)this.labelCollections.get(label);
            if (nodeLabel == null) {
                Resource resource = Resources.none();
                return resource;
            }
            Resource resource = nodeLabel.getResource();
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean isNodeUsableByQueue(Set<String> nodeLabels, Queue q) {
        if (nodeLabels == null || nodeLabels.isEmpty() || nodeLabels.size() == 1 && nodeLabels.contains("")) {
            return true;
        }
        for (String label : nodeLabels) {
            if (!q.accessibleNodeLabels.contains(label)) continue;
            return true;
        }
        return false;
    }

    private Map<String, CommonNodeLabelsManager.Host> cloneNodeMap() {
        HashSet<NodeId> nodesToCopy = new HashSet<NodeId>();
        for (String nodeName : this.nodeCollections.keySet()) {
            nodesToCopy.add(NodeId.newInstance((String)nodeName, (int)0));
        }
        return this.cloneNodeMap(nodesToCopy);
    }

    public boolean checkAccess(UserGroupInformation user) {
        return this.authorizer.isAdmin(user);
    }

    public void setRMContext(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RMNodeLabel> pullRMNodeLabelsInfo() {
        try {
            this.readLock.lock();
            ArrayList<RMNodeLabel> infos = new ArrayList<RMNodeLabel>();
            for (Map.Entry entry : this.labelCollections.entrySet()) {
                RMNodeLabel label = (RMNodeLabel)entry.getValue();
                infos.add(label.getCopy());
            }
            Collections.sort(infos);
            ArrayList<RMNodeLabel> arrayList = infos;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected static class Queue {
        protected Set<String> accessibleNodeLabels = Collections.newSetFromMap(new ConcurrentHashMap());
        protected Resource resource = Resource.newInstance((int)0, (int)0);

        protected Queue() {
        }
    }
}

