/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityDiagnosticConstant;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AllocationState;

public class ActivitiesLogger {
    private static final Log LOG = LogFactory.getLog(ActivitiesLogger.class);

    private static void recordActivity(ActivitiesManager activitiesManager, SchedulerNode node, String parentName, String childName, Priority priority, ActivityState state, String diagnostic, String type) {
        activitiesManager.addSchedulingActivityForNode(node.getNodeID(), parentName, childName, priority != null ? priority.toString() : null, state, diagnostic, type);
    }

    public static class NODE {
        public static void finishSkippedNodeAllocation(ActivitiesManager activitiesManager, SchedulerNode node) {
            NODE.finishAllocatedNodeAllocation(activitiesManager, node, null, AllocationState.SKIPPED);
        }

        public static void finishAllocatedNodeAllocation(ActivitiesManager activitiesManager, SchedulerNode node, ContainerId containerId, AllocationState containerState) {
            if (activitiesManager == null) {
                return;
            }
            if (activitiesManager.shouldRecordThisNode(node.getNodeID())) {
                activitiesManager.updateAllocationFinalState(node.getNodeID(), containerId, containerState);
            }
        }

        public static void finishNodeUpdateRecording(ActivitiesManager activitiesManager, NodeId nodeID) {
            if (activitiesManager == null) {
                return;
            }
            activitiesManager.finishNodeUpdateRecording(nodeID);
        }

        public static void startNodeUpdateRecording(ActivitiesManager activitiesManager, NodeId nodeID) {
            if (activitiesManager == null) {
                return;
            }
            activitiesManager.startNodeUpdateRecording(nodeID);
        }
    }

    public static class QUEUE {
        public static void recordQueueActivity(ActivitiesManager activitiesManager, SchedulerNode node, String parentQueueName, String queueName, ActivityState state, String diagnostic) {
            if (activitiesManager == null) {
                return;
            }
            if (activitiesManager.shouldRecordThisNode(node.getNodeID())) {
                ActivitiesLogger.recordActivity(activitiesManager, node, parentQueueName, queueName, null, state, diagnostic, null);
            }
        }
    }

    public static class APP {
        public static void recordSkippedAppActivityWithoutAllocation(ActivitiesManager activitiesManager, SchedulerNode node, SchedulerApplicationAttempt application, Priority priority, String diagnostic) {
            APP.recordAppActivityWithoutAllocation(activitiesManager, node, application, priority, diagnostic, ActivityState.SKIPPED);
        }

        public static void recordRejectedAppActivityFromLeafQueue(ActivitiesManager activitiesManager, SchedulerNode node, SchedulerApplicationAttempt application, Priority priority, String diagnostic) {
            String type = "app";
            if (activitiesManager == null) {
                return;
            }
            if (activitiesManager.shouldRecordThisNode(node.getNodeID())) {
                ActivitiesLogger.recordActivity(activitiesManager, node, application.getQueueName(), application.getApplicationId().toString(), priority, ActivityState.REJECTED, diagnostic, type);
            }
            APP.finishSkippedAppAllocationRecording(activitiesManager, application.getApplicationId(), ActivityState.REJECTED, diagnostic);
        }

        public static void recordAppActivityWithoutAllocation(ActivitiesManager activitiesManager, SchedulerNode node, SchedulerApplicationAttempt application, Priority priority, String diagnostic, ActivityState appState) {
            String type;
            if (activitiesManager == null) {
                return;
            }
            if (activitiesManager.shouldRecordThisNode(node.getNodeID())) {
                type = "container";
                activitiesManager.addSchedulingActivityForNode(node.getNodeID(), application.getApplicationId().toString(), null, priority.toString(), ActivityState.SKIPPED, diagnostic, type);
                type = "app";
                activitiesManager.addSchedulingActivityForNode(node.getNodeID(), application.getQueueName(), application.getApplicationId().toString(), application.getPriority().toString(), ActivityState.SKIPPED, ActivityDiagnosticConstant.EMPTY, type);
            }
            if (activitiesManager.shouldRecordThisApp(application.getApplicationId())) {
                type = "container";
                activitiesManager.addSchedulingActivityForApp(application.getApplicationId(), null, priority.toString(), appState, diagnostic, type);
            }
        }

        public static void recordAppActivityWithAllocation(ActivitiesManager activitiesManager, SchedulerNode node, SchedulerApplicationAttempt application, RMContainer updatedContainer, ActivityState activityState) {
            String type;
            if (activitiesManager == null) {
                return;
            }
            if (activitiesManager.shouldRecordThisNode(node.getNodeID())) {
                type = "container";
                activitiesManager.addSchedulingActivityForNode(node.getNodeID(), application.getApplicationId().toString(), updatedContainer.getContainer().toString(), updatedContainer.getContainer().getPriority().toString(), activityState, ActivityDiagnosticConstant.EMPTY, type);
                type = "app";
                activitiesManager.addSchedulingActivityForNode(node.getNodeID(), application.getQueueName(), application.getApplicationId().toString(), application.getPriority().toString(), ActivityState.ACCEPTED, ActivityDiagnosticConstant.EMPTY, type);
            }
            if (activitiesManager.shouldRecordThisApp(application.getApplicationId())) {
                type = "container";
                activitiesManager.addSchedulingActivityForApp(application.getApplicationId(), updatedContainer.getContainerId(), updatedContainer.getContainer().getPriority().toString(), activityState, ActivityDiagnosticConstant.EMPTY, type);
            }
        }

        public static void startAppAllocationRecording(ActivitiesManager activitiesManager, NodeId nodeId, long currentTime, SchedulerApplicationAttempt application) {
            if (activitiesManager == null) {
                return;
            }
            activitiesManager.startAppAllocationRecording(nodeId, currentTime, application);
        }

        public static void finishAllocatedAppAllocationRecording(ActivitiesManager activitiesManager, ApplicationId applicationId, ContainerId containerId, ActivityState containerState, String diagnostic) {
            if (activitiesManager == null) {
                return;
            }
            if (activitiesManager.shouldRecordThisApp(applicationId)) {
                activitiesManager.finishAppAllocationRecording(applicationId, containerId, containerState, diagnostic);
            }
        }

        public static void finishSkippedAppAllocationRecording(ActivitiesManager activitiesManager, ApplicationId applicationId, ActivityState containerState, String diagnostic) {
            APP.finishAllocatedAppAllocationRecording(activitiesManager, applicationId, null, containerState, diagnostic);
        }
    }
}

