/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.ScannerTimeoutException;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.MapReduceProtos;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ClientScanner
extends AbstractClientScanner {
    private final Log LOG = LogFactory.getLog(this.getClass());
    protected Scan scan;
    protected boolean closed = false;
    protected HRegionInfo currentRegion = null;
    protected ScannerCallable callable = null;
    protected final LinkedList<Result> cache = new LinkedList();
    protected final int caching;
    protected long lastNext;
    protected Result lastResult = null;
    protected final long maxScannerResultSize;
    private final HConnection connection;
    private final TableName tableName;
    protected final int scannerTimeout;
    protected boolean scanMetricsPublished = false;
    protected RpcRetryingCaller<Result[]> caller;

    public ClientScanner(Configuration conf, Scan scan, TableName tableName) throws IOException {
        this(conf, scan, tableName, HConnectionManager.getConnection(conf));
    }

    @Deprecated
    public ClientScanner(Configuration conf, Scan scan, byte[] tableName) throws IOException {
        this(conf, scan, TableName.valueOf((byte[])tableName));
    }

    public ClientScanner(Configuration conf, Scan scan, TableName tableName, HConnection connection) throws IOException {
        this(conf, scan, tableName, connection, new RpcRetryingCallerFactory(conf));
    }

    @Deprecated
    public ClientScanner(Configuration conf, Scan scan, byte[] tableName, HConnection connection) throws IOException {
        this(conf, scan, TableName.valueOf((byte[])tableName), connection, new RpcRetryingCallerFactory(conf));
    }

    public ClientScanner(Configuration conf, Scan scan, TableName tableName, HConnection connection, RpcRetryingCallerFactory rpcFactory) throws IOException {
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace((Object)("Scan table=" + tableName + ", startRow=" + Bytes.toStringBinary((byte[])scan.getStartRow())));
        }
        this.scan = scan;
        this.tableName = tableName;
        this.lastNext = System.currentTimeMillis();
        this.connection = connection;
        this.maxScannerResultSize = scan.getMaxResultSize() > 0L ? scan.getMaxResultSize() : conf.getLong(HConstants.HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE_KEY, HConstants.DEFAULT_HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE);
        this.scannerTimeout = HBaseConfiguration.getInt((Configuration)conf, (String)HConstants.HBASE_CLIENT_SCANNER_TIMEOUT_PERIOD, (String)HConstants.HBASE_REGIONSERVER_LEASE_PERIOD_KEY, (int)HConstants.DEFAULT_HBASE_CLIENT_SCANNER_TIMEOUT_PERIOD);
        this.initScanMetrics(scan);
        this.caching = this.scan.getCaching() > 0 ? this.scan.getCaching() : conf.getInt(HConstants.HBASE_CLIENT_SCANNER_CACHING, HConstants.DEFAULT_HBASE_CLIENT_SCANNER_CACHING);
        this.caller = rpcFactory.newCaller();
        this.initializeScannerInConstruction();
    }

    protected void initializeScannerInConstruction() throws IOException {
        this.nextScanner(this.caching, false);
    }

    protected HConnection getConnection() {
        return this.connection;
    }

    @Deprecated
    protected byte[] getTableName() {
        return this.tableName.getName();
    }

    protected TableName getTable() {
        return this.tableName;
    }

    protected Scan getScan() {
        return this.scan;
    }

    protected long getTimestamp() {
        return this.lastNext;
    }

    protected boolean checkScanStopRow(byte[] endKey) {
        byte[] stopRow;
        int cmp;
        return this.scan.getStopRow().length > 0 && (cmp = Bytes.compareTo((byte[])(stopRow = this.scan.getStopRow()), (int)0, (int)stopRow.length, (byte[])endKey, (int)0, (int)endKey.length)) <= 0;
    }

    protected boolean nextScanner(int nbRows, boolean done) throws IOException {
        byte[] localStartKey;
        if (this.callable != null) {
            this.callable.setClose();
            this.caller.callWithRetries(this.callable);
            this.callable = null;
        }
        if (this.currentRegion != null) {
            byte[] endKey = this.currentRegion.getEndKey();
            if (endKey == null || Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(endKey) || done) {
                this.close();
                if (this.LOG.isTraceEnabled()) {
                    this.LOG.trace((Object)("Finished " + this.currentRegion));
                }
                return false;
            }
            localStartKey = endKey;
            if (this.LOG.isTraceEnabled()) {
                this.LOG.trace((Object)("Finished " + this.currentRegion));
            }
        } else {
            localStartKey = this.scan.getStartRow();
        }
        if (this.LOG.isDebugEnabled() && this.currentRegion != null) {
            this.LOG.debug((Object)("Advancing internal scanner to startKey at '" + Bytes.toStringBinary((byte[])localStartKey) + "'"));
        }
        try {
            this.callable = this.getScannerCallable(localStartKey, nbRows);
            this.caller.callWithRetries(this.callable);
            this.currentRegion = this.callable.getHRegionInfo();
            if (this.scanMetrics != null) {
                this.scanMetrics.countOfRegions.incrementAndGet();
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        return true;
    }

    @InterfaceAudience.Private
    protected ScannerCallable getScannerCallable(byte[] localStartKey, int nbRows) {
        this.scan.setStartRow(localStartKey);
        ScannerCallable s = new ScannerCallable(this.getConnection(), this.getTable(), this.scan, this.scanMetrics);
        s.setCaching(nbRows);
        return s;
    }

    protected void writeScanMetrics() {
        if (this.scanMetrics == null || this.scanMetricsPublished) {
            return;
        }
        MapReduceProtos.ScanMetrics pScanMetrics = ProtobufUtil.toScanMetrics(this.scanMetrics);
        this.scan.setAttribute("scan.attributes.metrics.data", pScanMetrics.toByteArray());
        this.scanMetricsPublished = true;
    }

    @Override
    public Result next() throws IOException {
        if (this.cache.size() == 0 && this.closed) {
            return null;
        }
        if (this.cache.size() == 0) {
            Result[] values = null;
            long remainingResultSize = this.maxScannerResultSize;
            int countdown = this.caching;
            this.callable.setCaching(this.caching);
            boolean skipFirst = false;
            boolean retryAfterOutOfOrderException = true;
            do {
                try {
                    if (skipFirst) {
                        this.callable.setCaching(1);
                        values = this.caller.callWithRetries(this.callable);
                        this.callable.setCaching(this.caching);
                        skipFirst = false;
                    }
                    values = this.caller.callWithRetries(this.callable);
                    if (skipFirst && values != null && values.length == 1) {
                        skipFirst = false;
                        values = this.caller.callWithRetries(this.callable);
                    }
                    retryAfterOutOfOrderException = true;
                }
                catch (DoNotRetryIOException e) {
                    if (e instanceof UnknownScannerException) {
                        long timeout = this.lastNext + (long)this.scannerTimeout;
                        if (timeout < System.currentTimeMillis()) {
                            long elapsed = System.currentTimeMillis() - this.lastNext;
                            ScannerTimeoutException ex = new ScannerTimeoutException(elapsed + "ms passed since the last invocation, " + "timeout is currently set to " + this.scannerTimeout);
                            ex.initCause((Throwable)((Object)e));
                            throw ex;
                        }
                    } else {
                        Throwable cause = e.getCause();
                        if (!(cause != null && cause instanceof NotServingRegionException || cause != null && cause instanceof RegionServerStoppedException || e instanceof OutOfOrderScannerNextException)) {
                            throw e;
                        }
                    }
                    if (this.lastResult != null) {
                        this.scan.setStartRow(this.lastResult.getRow());
                        skipFirst = true;
                    }
                    if (e instanceof OutOfOrderScannerNextException) {
                        if (retryAfterOutOfOrderException) {
                            retryAfterOutOfOrderException = false;
                        } else {
                            throw new DoNotRetryIOException("Failed after retry of OutOfOrderScannerNextException: was there a rpc timeout?", (Throwable)((Object)e));
                        }
                    }
                    this.currentRegion = null;
                    this.callable = null;
                    continue;
                }
                long currentTime = System.currentTimeMillis();
                if (this.scanMetrics != null) {
                    this.scanMetrics.sumOfMillisSecBetweenNexts.addAndGet(currentTime - this.lastNext);
                }
                this.lastNext = currentTime;
                if (values == null || values.length <= 0) continue;
                for (Result rs : values) {
                    this.cache.add(rs);
                    for (Cell kv : rs.rawCells()) {
                        remainingResultSize -= KeyValueUtil.ensureKeyValue((Cell)kv).heapSize();
                    }
                    --countdown;
                    this.lastResult = rs;
                }
            } while (remainingResultSize > 0L && countdown > 0 && this.nextScanner(countdown, values == null));
        }
        if (this.cache.size() > 0) {
            return this.cache.poll();
        }
        this.writeScanMetrics();
        return null;
    }

    @Override
    public void close() {
        if (!this.scanMetricsPublished) {
            this.writeScanMetrics();
        }
        if (this.callable != null) {
            this.callable.setClose();
            try {
                this.caller.callWithRetries(this.callable);
            }
            catch (UnknownScannerException e) {
            }
            catch (IOException e) {
                this.LOG.warn((Object)("scanner failed to close. Exception follows: " + e));
            }
            this.callable = null;
        }
        this.closed = true;
    }
}

