/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.hadoop.hbase.io.SizedCellScanner;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestIPCUtil {
    public static final Log LOG = LogFactory.getLog(IPCUtil.class);
    IPCUtil util;
    private static final String COUNT = "--count=";
    private static final String SIZE = "--size=";

    @Before
    public void before() {
        this.util = new IPCUtil(new Configuration());
    }

    @Test
    public void testBuildCellBlock() throws IOException {
        TestIPCUtil.doBuildCellBlockUndoCellBlock(this.util, (Codec)new KeyValueCodec(), null);
        TestIPCUtil.doBuildCellBlockUndoCellBlock(this.util, (Codec)new KeyValueCodec(), (CompressionCodec)new DefaultCodec());
        TestIPCUtil.doBuildCellBlockUndoCellBlock(this.util, (Codec)new KeyValueCodec(), (CompressionCodec)new GzipCodec());
    }

    static void doBuildCellBlockUndoCellBlock(IPCUtil util, Codec codec, CompressionCodec compressor) throws IOException {
        TestIPCUtil.doBuildCellBlockUndoCellBlock(util, codec, compressor, 10, 1, false);
    }

    static void doBuildCellBlockUndoCellBlock(IPCUtil util, Codec codec, CompressionCodec compressor, int count, int size, boolean sized) throws IOException {
        Cell[] cells = TestIPCUtil.getCells(count, size);
        CellScanner cellScanner = sized ? TestIPCUtil.getSizedCellScanner(cells) : CellUtil.createCellScanner(Arrays.asList(cells).iterator());
        ByteBuffer bb = util.buildCellBlock(codec, compressor, cellScanner);
        cellScanner = util.createCellScanner(codec, compressor, bb.array(), 0, bb.limit());
        int i = 0;
        while (cellScanner.advance()) {
            ++i;
        }
        Assert.assertEquals((long)count, (long)i);
    }

    static CellScanner getSizedCellScanner(Cell[] cells) {
        int size = -1;
        for (Cell cell : cells) {
            size += CellUtil.estimatedSerializedSizeOf((Cell)cell);
        }
        final int totalSize = ClassSize.align((int)size);
        final CellScanner cellScanner = CellUtil.createCellScanner((Cell[])cells);
        return new SizedCellScanner(){

            public long heapSize() {
                return totalSize;
            }

            public Cell current() {
                return cellScanner.current();
            }

            public boolean advance() throws IOException {
                return cellScanner.advance();
            }
        };
    }

    static Cell[] getCells(int howMany) {
        return TestIPCUtil.getCells(howMany, 1024);
    }

    static Cell[] getCells(int howMany, int valueSize) {
        Cell[] cells = new Cell[howMany];
        byte[] value = new byte[valueSize];
        for (int i = 0; i < howMany; ++i) {
            byte[] index = Bytes.toBytes((int)i);
            KeyValue kv = new KeyValue(index, Bytes.toBytes((String)"f"), index, value);
            cells[i] = kv;
        }
        return cells;
    }

    private static void usage(int errCode) {
        System.out.println("Usage: IPCUtil [options]");
        System.out.println("Micro-benchmarking how changed sizes and counts work with buffer resizing");
        System.out.println(" --count  Count of Cells");
        System.out.println(" --size   Size of Cell values");
        System.out.println("Example: IPCUtil --count=1024 --size=1024");
        System.exit(errCode);
    }

    private static void timerTests(IPCUtil util, int count, int size, Codec codec, CompressionCodec compressor) throws IOException {
        int i;
        int cycles = 1000;
        StopWatch timer = new StopWatch();
        timer.start();
        for (i = 0; i < 1000; ++i) {
            TestIPCUtil.timerTest(util, timer, count, size, codec, compressor, false);
        }
        timer.stop();
        LOG.info((Object)("Codec=" + codec + ", compression=" + compressor + ", sized=" + false + ", count=" + count + ", size=" + size + ", + took=" + timer.getTime() + "ms"));
        timer.reset();
        timer.start();
        for (i = 0; i < 1000; ++i) {
            TestIPCUtil.timerTest(util, timer, count, size, codec, compressor, true);
        }
        timer.stop();
        LOG.info((Object)("Codec=" + codec + ", compression=" + compressor + ", sized=" + true + ", count=" + count + ", size=" + size + ", + took=" + timer.getTime() + "ms"));
    }

    private static void timerTest(IPCUtil util, StopWatch timer, int count, int size, Codec codec, CompressionCodec compressor, boolean sized) throws IOException {
        TestIPCUtil.doBuildCellBlockUndoCellBlock(util, codec, compressor, count, size, sized);
    }

    public static void main(String[] args) throws IOException {
        int count = 1024;
        int size = 10240;
        for (String arg : args) {
            if (arg.startsWith(COUNT)) {
                count = Integer.parseInt(arg.replace(COUNT, ""));
                continue;
            }
            if (arg.startsWith(SIZE)) {
                size = Integer.parseInt(arg.replace(SIZE, ""));
                continue;
            }
            TestIPCUtil.usage(1);
        }
        IPCUtil util = new IPCUtil(HBaseConfiguration.create());
        ((Log4JLogger)IPCUtil.LOG).getLogger().setLevel(Level.ALL);
        TestIPCUtil.timerTests(util, count, size, (Codec)new KeyValueCodec(), null);
        TestIPCUtil.timerTests(util, count, size, (Codec)new KeyValueCodec(), (CompressionCodec)new DefaultCodec());
        TestIPCUtil.timerTests(util, count, size, (Codec)new KeyValueCodec(), (CompressionCodec)new GzipCodec());
    }
}

