/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.zookeeper.KeeperException;

public class ZKDataMigrator
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(ZKDataMigrator.class);

    public int run(String[] as) throws Exception {
        Configuration conf = this.getConf();
        try (ZooKeeperWatcher zkw = null;){
            zkw = new ZooKeeperWatcher(this.getConf(), "Migrate ZK data to PB.", (Abortable)new ZKDataMigratorAbortable());
            if (ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)zkw.baseZNode) == -1) {
                LOG.info((Object)"No hbase related data available in zookeeper. returning..");
                int n = 0;
                return n;
            }
            List children = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)zkw.baseZNode);
            if (children == null) {
                LOG.info((Object)"No child nodes to mirgrate. returning..");
                int n = 0;
                return n;
            }
            String childPath = null;
            for (String child : children) {
                childPath = ZKUtil.joinZNode((String)zkw.baseZNode, (String)child);
                if (child.equals(conf.get("zookeeper.znode.rootserver", "root-region-server"))) {
                    ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.rs", "rs"))) {
                    ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.draining.rs", "draining"))) {
                    ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.master", "master"))) {
                    ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.backup.masters", "backup-masters"))) {
                    ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.state", "shutdown"))) {
                    ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.unassigned", "unassigned"))) {
                    ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.tableEnableDisable", "table")) || child.equals(conf.get("zookeeper.znode.masterTableEnableDisable", "table"))) {
                    this.checkAndMigrateTableStatesToPB(zkw);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.masterTableEnableDisable92", "table92"))) {
                    ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.splitlog", "splitlog"))) {
                    ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.replication", "replication"))) {
                    this.checkAndMigrateReplicationNodesToPB(zkw);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.clusterId", "hbaseid"))) {
                    ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)childPath);
                    continue;
                }
                if (child.equals("online-snapshot")) {
                    ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)childPath);
                    continue;
                }
                if (!child.equals(conf.get("zookeeper.znode.acl.parent", "acl"))) continue;
                ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)childPath);
            }
        }
        return 0;
    }

    private void checkAndMigrateTableStatesToPB(ZooKeeperWatcher zkw) throws KeeperException, InterruptedException {
        List tables = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)zkw.tableZNode);
        if (tables == null) {
            LOG.info((Object)"No table present to migrate table state to PB. returning..");
            return;
        }
        for (String table : tables) {
            String znode = ZKUtil.joinZNode((String)zkw.tableZNode, (String)table);
            if (table.equals("-ROOT-") || table.equals(".META.")) {
                ZKUtil.deleteNode((ZooKeeperWatcher)zkw, (String)znode);
                continue;
            }
            byte[] data = ZKUtil.getData((ZooKeeperWatcher)zkw, (String)znode);
            if (ProtobufUtil.isPBMagicPrefix((byte[])data)) continue;
            ZooKeeperProtos.Table.Builder builder = ZooKeeperProtos.Table.newBuilder();
            builder.setState(ZooKeeperProtos.Table.State.valueOf((String)Bytes.toString((byte[])data)));
            data = ProtobufUtil.prependPBMagic((byte[])builder.build().toByteArray());
            ZKUtil.setData((ZooKeeperWatcher)zkw, (String)znode, (byte[])data);
        }
    }

    private void checkAndMigrateReplicationNodesToPB(ZooKeeperWatcher zkw) throws KeeperException, InterruptedException {
        String replicationZnodeName = this.getConf().get("zookeeper.znode.replication", "replication");
        String replicationPath = ZKUtil.joinZNode((String)zkw.baseZNode, (String)replicationZnodeName);
        List replicationZnodes = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)replicationPath);
        if (replicationZnodes == null) {
            LOG.info((Object)"No replication related znodes present to migrate. returning..");
            return;
        }
        for (String child : replicationZnodes) {
            List rsList;
            String znode = ZKUtil.joinZNode((String)replicationPath, (String)child);
            if (child.equals(this.getConf().get("zookeeper.znode.replication.peers", "peers"))) {
                List peers = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)znode);
                if (peers == null || peers.isEmpty()) {
                    LOG.info((Object)"No peers present to migrate. returning..");
                    continue;
                }
                this.checkAndMigratePeerZnodesToPB(zkw, znode, peers);
                continue;
            }
            if (child.equals(this.getConf().get("zookeeper.znode.replication.state", "state"))) {
                ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)znode);
                continue;
            }
            if (!child.equals(this.getConf().get("zookeeper.znode.replication.rs", "rs")) || (rsList = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)znode)) == null || rsList.isEmpty()) continue;
            for (String rs : rsList) {
                this.checkAndMigrateQueuesToPB(zkw, znode, rs);
            }
        }
    }

    private void checkAndMigrateQueuesToPB(ZooKeeperWatcher zkw, String znode, String rs) throws KeeperException, KeeperException.NoNodeException, InterruptedException {
        String rsPath = ZKUtil.joinZNode((String)znode, (String)rs);
        List peers = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)rsPath);
        if (peers == null || peers.isEmpty()) {
            return;
        }
        String peerPath = null;
        for (String peer : peers) {
            peerPath = ZKUtil.joinZNode((String)rsPath, (String)peer);
            List files = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)peerPath);
            if (files == null || files.isEmpty()) continue;
            String filePath = null;
            for (String file : files) {
                filePath = ZKUtil.joinZNode((String)peerPath, (String)file);
                byte[] data = ZKUtil.getData((ZooKeeperWatcher)zkw, (String)filePath);
                if (data == null || Bytes.equals((byte[])data, (byte[])HConstants.EMPTY_BYTE_ARRAY) || ProtobufUtil.isPBMagicPrefix((byte[])data)) continue;
                ZKUtil.setData((ZooKeeperWatcher)zkw, (String)filePath, (byte[])ZKUtil.positionToByteArray((long)Long.parseLong(Bytes.toString((byte[])data))));
            }
        }
    }

    private void checkAndMigratePeerZnodesToPB(ZooKeeperWatcher zkw, String znode, List<String> peers) throws KeeperException, KeeperException.NoNodeException, InterruptedException {
        for (String peer : peers) {
            String peerStatePath;
            String peerZnode = ZKUtil.joinZNode((String)znode, (String)peer);
            byte[] data = ZKUtil.getData((ZooKeeperWatcher)zkw, (String)peerZnode);
            if (!ProtobufUtil.isPBMagicPrefix((byte[])data)) {
                this.migrateClusterKeyToPB(zkw, peerZnode, data);
            }
            if (ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)(peerStatePath = ZKUtil.joinZNode((String)peerZnode, (String)this.getConf().get("zookeeper.znode.replication.peers.state", "peer-state")))) == -1 || ProtobufUtil.isPBMagicPrefix((byte[])(data = ZKUtil.getData((ZooKeeperWatcher)zkw, (String)peerStatePath)))) continue;
            this.migratePeerStateToPB(zkw, data, peerStatePath);
        }
    }

    private void migrateClusterKeyToPB(ZooKeeperWatcher zkw, String peerZnode, byte[] data) throws KeeperException, KeeperException.NoNodeException {
        ZooKeeperProtos.ReplicationPeer peer = ZooKeeperProtos.ReplicationPeer.newBuilder().setClusterkey(Bytes.toString((byte[])data)).build();
        ZKUtil.setData((ZooKeeperWatcher)zkw, (String)peerZnode, (byte[])ProtobufUtil.prependPBMagic((byte[])peer.toByteArray()));
    }

    private void migratePeerStateToPB(ZooKeeperWatcher zkw, byte[] data, String peerStatePath) throws KeeperException, KeeperException.NoNodeException {
        String state = Bytes.toString((byte[])data);
        if (ZooKeeperProtos.ReplicationState.State.ENABLED.name().equals(state)) {
            ZKUtil.setData((ZooKeeperWatcher)zkw, (String)peerStatePath, (byte[])ReplicationStateZKBase.ENABLED_ZNODE_BYTES);
        } else if (ZooKeeperProtos.ReplicationState.State.DISABLED.name().equals(state)) {
            ZKUtil.setData((ZooKeeperWatcher)zkw, (String)peerStatePath, (byte[])ReplicationStateZKBase.DISABLED_ZNODE_BYTES);
        }
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new ZKDataMigrator(), (String[])args));
    }

    static class ZKDataMigratorAbortable
    implements Abortable {
        private boolean aborted = false;

        ZKDataMigratorAbortable() {
        }

        public void abort(String why, Throwable e) {
            LOG.error((Object)("Got aborted with reason: " + why + ", and error: " + e));
            this.aborted = true;
        }

        public boolean isAborted() {
            return this.aborted;
        }
    }
}

