/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.HConnectionKey;
import org.apache.hadoop.hbase.client.HRegionLocator;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptor;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorFactory;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class HConnectionTestingUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterConnection getMockedConnection(Configuration conf) throws ZooKeeperConnectionException {
        HConnectionKey connectionKey = new HConnectionKey(conf);
        Map map = ConnectionManager.CONNECTION_INSTANCES;
        synchronized (map) {
            ConnectionManager.HConnectionImplementation connection = (ConnectionManager.HConnectionImplementation)ConnectionManager.CONNECTION_INSTANCES.get(connectionKey);
            if (connection == null) {
                connection = (ConnectionManager.HConnectionImplementation)Mockito.mock(ConnectionManager.HConnectionImplementation.class);
                Mockito.when((Object)connection.getConfiguration()).thenReturn((Object)conf);
                Mockito.when((Object)connection.getRpcControllerFactory()).thenReturn(Mockito.mock(RpcControllerFactory.class));
                RpcRetryingCallerFactory callerFactory = new RpcRetryingCallerFactory(conf);
                Mockito.when((Object)connection.getRpcRetryingCallerFactory()).thenReturn((Object)callerFactory);
                ConnectionManager.CONNECTION_INSTANCES.put(connectionKey, connection);
            }
            return connection;
        }
    }

    private static void mockRegionLocator(final ConnectionManager.HConnectionImplementation connection) {
        try {
            Mockito.when((Object)connection.getRegionLocator((TableName)Mockito.any(TableName.class))).thenAnswer((Answer)new Answer<RegionLocator>(){

                public RegionLocator answer(InvocationOnMock invocation) throws Throwable {
                    TableName tableName = (TableName)invocation.getArguments()[0];
                    return new HRegionLocator(tableName, (ClusterConnection)connection);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static ClusterConnection getMockedConnectionAndDecorate(Configuration conf, AdminProtos.AdminService.BlockingInterface admin, ClientProtos.ClientService.BlockingInterface client, ServerName sn, HRegionInfo hri) throws IOException {
        ConnectionManager.HConnectionImplementation c = (ConnectionManager.HConnectionImplementation)Mockito.mock(ConnectionManager.HConnectionImplementation.class);
        Mockito.when((Object)c.getConfiguration()).thenReturn((Object)conf);
        ConnectionManager.CONNECTION_INSTANCES.put(new HConnectionKey(conf), c);
        ((ConnectionManager.HConnectionImplementation)Mockito.doNothing().when((Object)c)).close();
        HRegionLocation loc = new HRegionLocation(hri, sn);
        HConnectionTestingUtility.mockRegionLocator(c);
        Mockito.when((Object)c.getRegionLocation((TableName)Mockito.any(), (byte[])Mockito.any(), Mockito.anyBoolean())).thenReturn((Object)loc);
        Mockito.when((Object)c.locateRegion((TableName)Mockito.any(), (byte[])Mockito.any())).thenReturn((Object)loc);
        Mockito.when((Object)c.locateRegion((TableName)Mockito.any(), (byte[])Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyInt())).thenReturn((Object)new RegionLocations(new HRegionLocation[]{loc}));
        if (admin != null) {
            Mockito.when((Object)c.getAdmin((ServerName)Mockito.any(ServerName.class))).thenReturn((Object)admin);
        }
        if (client != null) {
            Mockito.when((Object)c.getClient((ServerName)Mockito.any(ServerName.class))).thenReturn((Object)client);
        }
        NonceGenerator ng = (NonceGenerator)Mockito.mock(NonceGenerator.class);
        Mockito.when((Object)c.getNonceGenerator()).thenReturn((Object)ng);
        AsyncProcess asyncProcess = new AsyncProcess((ClusterConnection)c, conf, null, RpcRetryingCallerFactory.instantiate((Configuration)conf), false, RpcControllerFactory.instantiate((Configuration)conf), conf.getInt("hbase.rpc.timeout", 60000));
        Mockito.when((Object)c.getAsyncProcess()).thenReturn((Object)asyncProcess);
        ((ConnectionManager.HConnectionImplementation)Mockito.doNothing().when((Object)c)).incCount();
        ((ConnectionManager.HConnectionImplementation)Mockito.doNothing().when((Object)c)).decCount();
        Mockito.when((Object)c.getNewRpcRetryingCallerFactory(conf)).thenReturn((Object)RpcRetryingCallerFactory.instantiate((Configuration)conf, (RetryingCallerInterceptor)RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR, null));
        Mockito.when((Object)c.getRpcControllerFactory()).thenReturn(Mockito.mock(RpcControllerFactory.class));
        HTableInterface t = (HTableInterface)Mockito.mock(HTableInterface.class);
        Mockito.when((Object)c.getTable((TableName)Mockito.any())).thenReturn((Object)t);
        ResultScanner rs = (ResultScanner)Mockito.mock(ResultScanner.class);
        Mockito.when((Object)t.getScanner((Scan)Mockito.any())).thenReturn((Object)rs);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterConnection getSpiedConnection(Configuration conf) throws IOException {
        HConnectionKey connectionKey = new HConnectionKey(conf);
        Map map = ConnectionManager.CONNECTION_INSTANCES;
        synchronized (map) {
            ConnectionManager.HConnectionImplementation connection = (ConnectionManager.HConnectionImplementation)ConnectionManager.CONNECTION_INSTANCES.get(connectionKey);
            if (connection == null) {
                connection = (ConnectionManager.HConnectionImplementation)Mockito.spy((Object)new ConnectionManager.HConnectionImplementation(conf, true));
                ConnectionManager.CONNECTION_INSTANCES.put(connectionKey, connection);
            }
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterConnection getSpiedClusterConnection(Configuration conf) throws IOException {
        HConnectionKey connectionKey = new HConnectionKey(conf);
        Map map = ConnectionManager.CONNECTION_INSTANCES;
        synchronized (map) {
            ConnectionManager.HConnectionImplementation connection = (ConnectionManager.HConnectionImplementation)ConnectionManager.CONNECTION_INSTANCES.get(connectionKey);
            if (connection == null) {
                connection = (ConnectionManager.HConnectionImplementation)Mockito.spy((Object)new ConnectionManager.HConnectionImplementation(conf, true));
                ConnectionManager.CONNECTION_INSTANCES.put(connectionKey, connection);
            }
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getConnectionCount() {
        Map map = ConnectionManager.CONNECTION_INSTANCES;
        synchronized (map) {
            return ConnectionManager.CONNECTION_INSTANCES.size();
        }
    }

    public static ConnectionManager.HConnectionImplementation requireHConnImpl(Connection conn) {
        Assert.assertNotNull((String)"Cannot operate on a null Connection", (Object)conn);
        Assert.assertEquals((String)"This method requires an HConnectionImplementation", ConnectionManager.HConnectionImplementation.class, conn.getClass());
        return (ConnectionManager.HConnectionImplementation)conn;
    }

    public static RecoverableZooKeeper unwrapZK(Connection conn) throws IOException {
        return HConnectionTestingUtility.requireHConnImpl(conn).getKeepAliveZooKeeperWatcher().getRecoverableZooKeeper();
    }

    public static void clearRegionCache(Connection conn) throws IOException {
        HConnectionTestingUtility.requireHConnImpl(conn).clearRegionCache();
    }

    public static class SleepAtFirstRpcCall
    extends BaseRegionObserver {
        static final AtomicLong ct = new AtomicLong(0L);
        static final String SLEEP_TIME_CONF_KEY = "hbase.coprocessor.SleepAtFirstRpcCall.sleepTime";
        static final long DEFAULT_SLEEP_TIME = 2000L;
        static final AtomicLong sleepTime = new AtomicLong(2000L);

        public void postOpen(ObserverContext<RegionCoprocessorEnvironment> e) {
            RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)e.getEnvironment();
            Configuration conf = env.getConfiguration();
            sleepTime.set(conf.getLong(SLEEP_TIME_CONF_KEY, 2000L));
        }

        public Result postIncrement(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment, Result result) throws IOException {
            if (ct.incrementAndGet() == 1L) {
                Threads.sleep((long)sleepTime.get());
            }
            return result;
        }

        public Result postAppend(ObserverContext<RegionCoprocessorEnvironment> e, Append append, Result result) throws IOException {
            if (ct.incrementAndGet() == 1L) {
                Threads.sleep((long)sleepTime.get());
            }
            return result;
        }
    }
}

